import logging
from abc import ABC, abstractmethod

from .domain.campaign import refresh_campaigns_display_probability
from .domain.unstop_campaigns import stop_campaigns_date_end

logger = logging.getLogger(__name__)


class BaseTaskExecutor(ABC):
    task_type: str = None

    @classmethod
    @abstractmethod
    async def do_run(cls, _):
        raise NotImplementedError()


class StopCampaignsDateEnd(BaseTaskExecutor):
    task_type = "stop_campaigns_date_end"

    @classmethod
    async def do_run(cls, _):
        await stop_campaigns_date_end()


class RefreshDisplayProbabilityForCampaigns(BaseTaskExecutor):
    task_type = "refresh_display_probability_for_campaigns"

    @classmethod
    async def do_run(cls, _):
        await refresh_campaigns_display_probability()
