PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    maps_adv/adv_store

    maps_adv/common/helpers

    contrib/python/Faker
    contrib/python/pytest
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock
)

SRCDIR(
    maps_adv/adv_store
)

PY_SRCS(
    __init__.py
    conftest.py
    faker_provider.py
    factory.py
    db/conftest.py
    utils.py
)

TEST_SRCS(
    api/test_get_status_history_api.py
    api/test_system.py
    api_provider/test_get_status_history_api_provider.py
    data_managers/api/test_get_status_history.py
    data_managers/test_append_status_history_entry.py
    data_managers/test_campaign_change_log.py
    data_managers/test_campaign_display_probability.py
    data_managers/test_common_data_managers.py
    data_managers/test_get_current_campaign_status.py
    data_managers/test_stop_campaigns_date_end.py
    db/test_actions.py
    db/test_billing.py
    db/test_campaign.py
    db/test_creatives.py
    db/test_placing.py
    db/test_status_history.py
    db/test_week_schedule.py
    domain/test_campaign_display_probability.py
    domain/test_get_status_history_domain.py
    domain/test_stop_campaigns_date_end.py
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

END()
