import argparse
import logging

from maps_adv.adv_store.v2.lib import Application
from maps_adv.config_loader import Config

_config = {
    "DATABASE_URL": {},
    "DASHBOARD_API_URL": {},
    "WARDEN_URL": {"default": None},
    "BILLING_API_URL": {"default": None},
    "YT_CLUSTER": {"default": "hahn"},
    "YT_TOKEN": {},
    "YT_CHANGE_LOGS_TABLE": {},
    "PING_V1_URL": {"default": "http://127.0.0.1:8080/ping"},
    "USE_DIRECT_MODERATION": {"default": False, "converter": bool},
    "LOGBROKER_CLUSTER": {"default": None},
    "LOGBROKER_PORT": {"default": None},
    "LOGBROKER_AUTH_TOKEN": {"default": None},
    "LOGBROKER_SOURCE_ID": {"default": None, "converter": str.encode},
    "LOGBROKER_DIRECT_MODERATION_TOPIC_OUT": {"default": None},
    "LOGBROKER_DIRECT_MODERATION_TOPIC_IN": {"default": None},
    "LOGBROKER_DIRECT_MODERATION_CONSUMER_ID": {"default": None},
    "AVATAR_MDS_BASE_URL": {"default": "https://avatars.mds.yandex.net"},
    # Experiments
    # TODO(megadiablo) Выкинуть флаг после завершения эксперемента
    #                  GEOADVDEV-2493
    "EXPERIMENT_CALCULATE_DISPLAY_CHANCE_FROM_CPM": {
        "default": False,
        "converter": bool,
    },
}

config = Config(_config)

parser = argparse.ArgumentParser("Adv store http server")
parser.add_argument("--host")
parser.add_argument("--port", type=int)
parser.add_argument("--config")


def main():
    logging.basicConfig(level=logging.DEBUG)

    args = parser.parse_args()
    config.init(args.config)

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
