from maps_adv.adv_store.v2.lib.domains import EventsDomain

from .base import with_schemas
from maps_adv.adv_store.api.schemas import (
    CampaignEventDataListSchema,
    CampaignEventForOrderIdsInputSchema,
    CampaignEventListSchema,
)


class EventsApiProvider:
    __slots__ = ("_domain",)

    _domain: EventsDomain

    def __init__(self, domain: EventsDomain):
        self._domain = domain

    @with_schemas(
        input_schema=CampaignEventForOrderIdsInputSchema,
        output_schema=CampaignEventListSchema,
    )
    async def retrieve_campaigns_events_by_orders(self, **kwargs) -> dict:
        result = await self._domain.retrieve_campaigns_events_by_orders(**kwargs)
        return {"events": result}

    @with_schemas(input_schema=CampaignEventDataListSchema)
    async def create_campaign_events(self, **kwargs) -> None:
        await self._domain.create_campaign_events(**kwargs)
