from typing import List

from maps_adv.adv_store.api.schemas import (
    CampaignModerationInfoListSchema,
    CampaignModerationReviewSchema,
)
from maps_adv.adv_store.api.schemas.enums import ModerationResolutionEnum
from maps_adv.adv_store.v2.lib.domains import ModerationDomain

from .base import with_schemas


class ModerationApiProvider:
    __slots__ = ("_domain",)

    _domain: ModerationDomain

    def __init__(self, domain: ModerationDomain):
        self._domain = domain

    @with_schemas(output_schema=CampaignModerationInfoListSchema)
    async def list_campaigns(self) -> dict:
        got = await self._domain.list_campaigns()
        return {"campaigns": got}

    @with_schemas(input_schema=CampaignModerationReviewSchema)
    async def review_campaign(
        self,
        campaign_id: int,
        resolution: ModerationResolutionEnum,
        author_id: int,
        comment: str,
        verdicts: List[int],
    ) -> None:
        await self._domain.review_campaign(
            campaign_id=campaign_id,
            resolution=resolution,
            author_id=author_id,
            comment=comment,
            verdicts=verdicts,
        )
