from aiohttp.web import Request, Response

from .api_providers.events import EventsApiProvider

__all__ = ["Resources"]


class Resources:
    __slots__ = ("_provider",)

    _provider: EventsApiProvider

    def __init__(self, provider: EventsApiProvider):
        self._provider = provider

    async def retrieve_campaigns_events_by_orders(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.retrieve_campaigns_events_by_orders(body)
        return Response(body=result, status=200)

    async def create_campaign_events(self, request: Request) -> Response:
        try:
            body = await request.read()
            await self._provider.create_campaign_events(body)
        except Exception as e:
            raise e
        return Response(status=200)
