from aiohttp.web import Request, Response

from .api_providers.moderation import ModerationApiProvider

__all__ = ["Resources"]


class Resources:
    __slots__ = ("_provider",)

    _provider: ModerationApiProvider

    def __init__(self, provider: ModerationApiProvider):
        self._provider = provider

    async def list_campaigns(self, request: Request) -> Response:
        got = await self._provider.list_campaigns()
        return Response(body=got, status=200)

    async def review_campaign(self, request: Request) -> Response:
        body = await request.read()
        await self._provider.review_campaign(body)
        return Response()
