from aiohttp import ClientSession
from aiohttp.web import Request, Response

from maps_adv.adv_store.v2.lib.db import DB

__all__ = ["Resources"]


class Resources:
    __slots__ = ("_db", "_ping_v1_url")

    _db: DB

    def __init__(self, db: DB, ping_v1_url: str):
        self._db = db
        self._ping_v1_url = ping_v1_url

    async def ping(self, req: Request) -> Response:
        await self._db.healthcheck()

        async with ClientSession() as session:
            async with session.request("GET", self._ping_v1_url) as response:
                if response.status not in (200, 204):
                    raise Exception("Invalid response status for ping of version 1")

        return Response(status=200)
