from typing import List

from maps_adv.adv_store.api.schemas.enums import (
    CampaignDirectModerationWorkflowEnum,
    YesNoEnum,
)
from maps_adv.common.helpers.enums import CampaignTypeEnum


class DirectModerationMeta:
    def __str__(self) -> str:
        return str(self.__dict__)

    campaign_id: int
    version_id: int

    def __init__(self, campaign_id: int, version_id: int):
        self.campaign_id = campaign_id
        self.version_id = version_id

    def __eq__(self, o: object) -> bool:
        if not isinstance(o, DirectModerationMeta):
            return NotImplemented

        return self.campaign_id == o.campaign_id and self.version_id == o.version_id


class DirectModerationData:
    pass


class DirectModerationDataZeroSpeedBanner(DirectModerationData):
    def __str__(self) -> str:
        return str(self.__dict__)

    image: str
    disclaimer: str
    title: str
    description: str
    terms: str
    actions: List[dict]

    def __init__(
        self,
        image: str,
        disclaimer: str,
        title: str,
        description: str,
        terms: str,
        actions: List[dict],
    ):
        self.image = image
        self.disclaimer = disclaimer
        self.title = title
        self.description = description
        self.terms = terms
        self.actions = actions

    def __eq__(self, o: object) -> bool:

        if not isinstance(o, DirectModerationDataZeroSpeedBanner):
            return NotImplemented

        return (
            self.image == o.image
            and self.disclaimer == o.disclaimer
            and self.title == o.title
            and self.description == o.description
            and self.terms == o.terms
            and self.actions == o.actions
        )


class DirectModerationOutgoing:

    meta: DirectModerationMeta
    type: str
    workflow: CampaignDirectModerationWorkflowEnum
    country_geo_id: int
    verdictor_uid: int
    data: DirectModerationData

    def __init__(
        self,
        meta: DirectModerationMeta,
        type: CampaignTypeEnum,
        workflow: CampaignDirectModerationWorkflowEnum,
        country_geo_id: int,
        verdictor_uid: int,
        data: DirectModerationData,
    ):
        self.meta = meta
        self.type = type.name  # Direct moderation wants it as string
        self.workflow = workflow.name  # Direct moderation wants it as string
        self.country_geo_id = country_geo_id
        self.verdictor_uid = verdictor_uid
        self.data = data

    def __eq__(self, o: object) -> bool:

        if not isinstance(o, DirectModerationOutgoing):
            return NotImplemented

        return (
            self.meta == o.meta
            and self.type == o.type
            and self.workflow == o.workflow
            and self.country_geo_id == o.country_geo_id
            and self.verdictor_uid == o.verdictor_uid
            and self.data == o.data
        )


class DirectModerationIncoming:

    meta: DirectModerationMeta
    verdict: YesNoEnum
    reasons: List[int]

    def __init__(self, meta: DirectModerationMeta, verdict: str, reasons: List[int]):
        self.meta = meta
        self.verdict = verdict
        self.reasons = reasons

    def __eq__(self, o: object) -> bool:
        if not isinstance(o, DirectModerationIncoming):
            return NotImplemented

        return (
            self.meta == o.meta
            and self.verdict == o.verdict
            and self.reasons == o.reasons
        )

    def __str__(self) -> str:
        return str(self.__dict__)
