insert_action_search = """
    INSERT INTO action_search (campaign_id, title, organizations, history_text, main)
    VALUES ($1, $2, $3, $4, $5)
"""

insert_action_open_site = """
    INSERT INTO action_open_site (campaign_id, title, url, main)
    VALUES ($1, $2, $3, $4)
"""

insert_action_phone_call = """
    INSERT INTO action_phone_call (campaign_id, title, phone, main)
    VALUES ($1, $2, $3, $4)
"""

insert_action_download_app = """
    INSERT INTO action_download_app (campaign_id, title, google_play_id, app_store_id, url, main)
    VALUES ($1, $2, $3, $4, $5, $6)
"""  # noqa: E501

insert_action_promocode = """
    INSERT INTO action_promocode (campaign_id, promocode, main)
    VALUES ($1, $2, $3)
"""

insert_action_resolve_uri = """
    INSERT INTO action_resolve_uri (campaign_id, uri, action_type, target, dialog, main)
    VALUES ($1, $2, $3::actiontypeenum, $4::resolveuritargetenum, $5, $6)
"""

insert_action_add_point_to_route = """
    INSERT INTO action_add_point_to_route (campaign_id, latitude, longitude, main)
    VALUES ($1, $2, $3, $4)
"""

remove_campaign_actions = """
    WITH
        delete_search AS (DELETE FROM action_search WHERE campaign_id = $1),
        delete_open_site AS (DELETE FROM action_open_site WHERE campaign_id = $1),
        delete_phone_call AS (DELETE FROM action_phone_call WHERE campaign_id = $1),
        delete_download_app AS (DELETE FROM action_download_app WHERE campaign_id = $1),
        delete_promocode AS (DELETE FROM action_promocode WHERE campaign_id = $1),
        delete_resolve_uri AS (DELETE FROM action_resolve_uri WHERE campaign_id = $1),
        delete_add_point_to_route AS (DELETE FROM action_add_point_to_route WHERE campaign_id = $1)
    SELECT 1
"""  # noqa: E501
