insert_creative_pin = """
    INSERT INTO creative_pin (campaign_id, images, title, subtitle)
    VALUES ($1, $2, $3, $4)
"""

insert_creative_billboard = """
    INSERT INTO creative_billboard (campaign_id, images, images_v2, title, description)
    VALUES ($1, $2, $3, $4, $5)
"""

insert_creative_icon = """
    INSERT INTO creative_icon (campaign_id, images, position, title)
    VALUES ($1, $2, $3, $4)
"""

insert_creative_pin_search = """
    INSERT INTO creative_pin_search (campaign_id, images, title, organizations)
    VALUES ($1, $2, $3, $4)
"""

insert_creative_logo_and_text = """
    INSERT INTO creative_logo_and_text (campaign_id, images, text)
    VALUES ($1, $2, $3)
"""

insert_creative_text = """
    INSERT INTO creative_text (campaign_id, text, disclaimer)
    VALUES ($1, $2, $3)
"""

insert_creative_via_point = """
    INSERT INTO creative_via_point (
        campaign_id, images, button_text_active, button_text_inactive, description
    )
    VALUES ($1, $2, $3, $4, $5)
"""

insert_creative_banner = """
    INSERT INTO creative_banner (
        campaign_id, images, disclaimer, show_ads_label, description, title, terms
    )
    VALUES ($1, $2, $3, $4, $5, $6, $7)
"""

insert_creative_audio_banner = """
    INSERT INTO creative_audio_banner (
        campaign_id, images, left_anchor, audio_file_url
    )
    VALUES ($1, $2, $3, $4)
"""

remove_campaign_creatives = """
    WITH
        delete_pin AS (DELETE FROM creative_pin WHERE campaign_id = $1),
        delete_billboard AS (DELETE FROM creative_billboard WHERE campaign_id = $1),
        delete_icon AS (DELETE FROM creative_icon WHERE campaign_id = $1),
        delete_pin_search AS (DELETE FROM creative_pin_search WHERE campaign_id = $1),
        delete_logo_and_text AS (DELETE FROM creative_logo_and_text WHERE campaign_id = $1),
        delete_text AS (DELETE FROM creative_text WHERE campaign_id = $1),
        delete_via_point AS (DELETE FROM creative_via_point WHERE campaign_id = $1),
        delete_banner AS (DELETE FROM creative_banner WHERE campaign_id = $1),
        delete_audio_banner AS (DELETE FROM creative_audio_banner WHERE campaign_id = $1)
    SELECT 1
"""  # noqa: E501
