create_campaign_event = """
    INSERT INTO campaign_event (
        timestamp ,
        campaign_id,
        event_type,
        event_data
    )
    VALUES ($1, $2, $3, $4)
    RETURNING id
"""

retrieve_campaigns_events_by_orders = """
    WITH campaign_ids AS (
        SELECT id, name, order_id as billing_order_id, manul_order_id FROM campaign
        WHERE order_id = ANY($1::bigint[]) OR manul_order_id = ANY($2::bigint[])
    )
    SELECT
        campaign_event.id,
        campaign_event.timestamp,
        campaign_event.campaign_id,
        campaign_ids.name as campaign_name,
        campaign_ids.billing_order_id,
        campaign_ids.manul_order_id,
        campaign_event.event_type,
        campaign_event.event_data
    FROM campaign_event
    INNER JOIN campaign_ids ON campaign_ids.id = campaign_event.campaign_id
    WHERE campaign_event.id <@ int8range(NULL, $5) -- events with ids less than specified id
    AND campaign_event.timestamp <@ tstzrange($3, $4, '[]') -- events within specified time range
    ORDER BY timestamp DESC
    LIMIT $6
"""  # noqa: E501
