list_moderation_campaigns = """
    SELECT
        campaign.id,
        campaign.name,
        campaign.campaign_type,
        campaign.start_datetime,
        campaign.end_datetime,
        campaign.timezone,
        campaign.platforms,
        campaign.order_id,
        campaign.manul_order_id,
        statuses_q.request_datetime,
        COALESCE(billing_cpa.budget, billing_cpm.budget) as budget
    FROM campaign
    JOIN (
        SELECT
            campaign_id,
            status,
            changed_datetime as request_datetime
        FROM status_history
        WHERE (campaign_id, changed_datetime) IN (
            SELECT campaign_id, max(changed_datetime)
            FROM status_history
            GROUP BY campaign_id
        )
    ) as statuses_q ON campaign.id = statuses_q.campaign_id
    JOIN campaign_billing ON campaign.billing_id = campaign_billing.id
    LEFT JOIN billing_cpm ON campaign_billing.cpm_id = billing_cpm.id
    LEFT JOIN billing_cpa ON campaign_billing.cpa_id = billing_cpa.id
    WHERE statuses_q.status = 'REVIEW'
    ORDER BY statuses_q.request_datetime DESC
"""

create_direct_moderation_for_campaign = """
    INSERT INTO campaign_direct_moderation (
        created_at,
        campaign_id,
        reviewer_uid,
        status,
        workflow,
        verdicts
    )
    VALUES (now(), $1, $2, 'NEW', $3, $4)
    RETURNING id
"""

update_direct_moderation_status = """
    UPDATE campaign_direct_moderation
    SET status = $2,
        verdicts = $3
    WHERE id = $1
"""

list_direct_moderations_with_status = (
    "SELECT * FROM campaign_direct_moderation WHERE status = $1"
)

retrieve_direct_moderation_by_id = """
    SELECT * FROM campaign_direct_moderation
    WHERE id = $1
"""
