from .engine import DB


class DbEnumConverter:
    _name_getter = lambda v: v.name  # noqa: E731

    @classmethod
    def to_enum(cls, enum_class, value):
        if isinstance(value, (list, tuple)):
            return type(value)(map(lambda v: enum_class[v], value))
        elif value is not None:
            return enum_class[value]
        else:
            return None

    @classmethod
    def from_enum(cls, value):
        if isinstance(value, (list, tuple)):
            return type(value)(map(cls._name_getter, value))
        elif value is not None:
            return value.name
        else:
            return None


db_enum_converter = DbEnumConverter()


__all__ = ["DB", "db_enum_converter"]
