import sqlalchemy as sa
from sqlalchemy.dialects.postgresql import JSONB

__all__ = ["Column", "MoneyColumn", "DateTimeTZ", "ImagesColumn"]


class Column(sa.Column):
    def __init__(self, *args, **kwargs):
        kwargs.setdefault("nullable", False)
        super().__init__(*args, **kwargs)


class MoneyColumn(Column):
    def __init__(self, *args, **kwargs):
        kwargs["type_"] = sa.Numeric(precision=18, scale=4)
        super().__init__(args[0], **kwargs)


class DateTimeTZ(sa.DateTime):
    def __init__(self, *args, **kwargs):
        kwargs["timezone"] = True
        super().__init__(*args, **kwargs)


class ImagesColumn(Column):
    def __init__(self, *args, **kwargs):
        kwargs["type_"] = JSONB
        super().__init__(args[0], **kwargs)
