"""initial

Revision ID: b6f36a974e99
Revises:
Create Date: 2019-08-23 11:27:15.240826

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

import maps_adv.adv_store.v2.lib.db.columns
import maps_adv.adv_store.v2.lib.db.constraints

# revision identifiers, used by Alembic.
revision = "b6f36a974e99"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "billing_cpa",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("cost", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.Column("budget", sa.Numeric(precision=18, scale=4), nullable=True),
        sa.Column("daily_budget", sa.Numeric(precision=18, scale=4), nullable=True),
        sa.CheckConstraint("budget > 0.0", name=op.f("ck_billing_cpa_budget_positive")),
        sa.CheckConstraint("cost > 0.0", name=op.f("ck_billing_cpa_cost_positive")),
        sa.CheckConstraint(
            "daily_budget > 0.0", name=op.f("ck_billing_cpa_daily_budget_positive")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_billing_cpa")),
    )
    op.create_table(
        "billing_cpm",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("cost", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.Column("budget", sa.Numeric(precision=18, scale=4), nullable=True),
        sa.Column("daily_budget", sa.Numeric(precision=18, scale=4), nullable=True),
        sa.CheckConstraint("budget > 0.0", name=op.f("ck_billing_cpm_budget_positive")),
        sa.CheckConstraint("cost > 0.0", name=op.f("ck_billing_cpm_cost_positive")),
        sa.CheckConstraint(
            "daily_budget > 0.0", name=op.f("ck_billing_cpm_daily_budget_positive")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_billing_cpm")),
    )
    op.create_table(
        "billing_fix",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column(
            "time_interval",
            sa.Enum("DAILY", "WEEKLY", "MONTHLY", name="fixtimeintervalenum"),
            nullable=False,
        ),
        sa.Column("cost", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.CheckConstraint("cost > 0.0", name=op.f("ck_billing_fix_cost_positive")),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_billing_fix")),
    )
    op.create_table(
        "campaign_billing",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("fix_id", sa.BigInteger(), nullable=True),
        sa.Column("cpm_id", sa.BigInteger(), nullable=True),
        sa.Column("cpa_id", sa.BigInteger(), nullable=True),
        sa.CheckConstraint(
            "(fix_id is not null)::integer + (cpm_id is not null)::integer "
            "+ (cpa_id is not null)::integer = 1",
            name=op.f("ck_campaign_billing_one_of_fix_id_cpm_id_cpa_id"),
        ),
        sa.ForeignKeyConstraint(
            ["cpa_id"],
            ["billing_cpa.id"],
            name=op.f("fk_campaign_billing_cpa_id_billing_cpa"),
        ),
        sa.ForeignKeyConstraint(
            ["cpm_id"],
            ["billing_cpm.id"],
            name=op.f("fk_campaign_billing_cpm_id_billing_cpm"),
        ),
        sa.ForeignKeyConstraint(
            ["fix_id"],
            ["billing_fix.id"],
            name=op.f("fk_campaign_billing_fix_id_billing_fix"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_campaign_billing")),
    )
    op.create_table(
        "campaign",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("author_id", sa.BigInteger(), nullable=False),
        sa.Column("name", sa.UnicodeText(), nullable=False),
        sa.Column(
            "publication_envs",
            sa.ARRAY(sa.Enum("PRODUCTION", "DATA_TESTING", name="publicationenvenum")),
            nullable=False,
        ),
        sa.Column(
            "campaign_type",
            sa.Enum(
                "PIN_ON_ROUTE",
                "BILLBOARD",
                "ZERO_SPEED_BANNER",
                "CATEGORY_SEARCH",
                "ROUTE_BANNER",
                "VIA_POINTS",
                "OVERVIEW_BANNER",
                "PROMOCODE",
                name="campaigntypeenum",
            ),
            nullable=False,
        ),
        sa.Column(
            "start_datetime",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column(
            "end_datetime",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column("timezone", sa.Text(), nullable=False),
        sa.Column("billing_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "platforms",
            sa.ARRAY(sa.Enum("NAVI", "MAPS", "METRO", name="platformenum")),
            nullable=False,
        ),
        sa.Column("order_id", sa.BigInteger(), nullable=True),
        sa.Column("comment", sa.UnicodeText(), server_default="", nullable=False),
        sa.Column("user_display_limit", sa.Integer(), nullable=True),
        sa.Column("user_daily_display_limit", sa.Integer(), nullable=True),
        sa.Column(
            "targeting",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default="{}",
            nullable=False,
        ),
        sa.Column(
            "changed_datetime",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.CheckConstraint(
            "jsonb_typeof(targeting) = 'object'",
            name=op.f("ck_campaign_targeting_jsonb_object"),
        ),
        sa.CheckConstraint(
            "cardinality(platforms) > 0",
            name=op.f("ck_campaign_platforms_not_empty_array"),
        ),
        sa.CheckConstraint(
            "cardinality(publication_envs) > 0",
            name=op.f("ck_campaign_publication_envs_not_empty_array"),
        ),
        sa.CheckConstraint(
            "length(name) > 0", name=op.f("ck_campaign_name_not_empty_string")
        ),
        sa.CheckConstraint(
            "length(timezone) > 0", name=op.f("ck_campaign_timezone_not_empty_string")
        ),
        sa.CheckConstraint(
            "order_id >= 0", name=op.f("ck_campaign_order_id_not_negative")
        ),
        sa.CheckConstraint(
            "start_datetime < end_datetime",
            name=op.f("ck_campaign_start_datetime_lt_end_datetime"),
        ),
        sa.CheckConstraint(
            "user_daily_display_limit >= 0",
            name=op.f("ck_campaign_user_daily_display_limit_not_negative"),
        ),
        sa.CheckConstraint(
            "user_display_limit >= 0",
            name=op.f("ck_campaign_user_display_limit_not_negative"),
        ),
        sa.ForeignKeyConstraint(
            ["billing_id"],
            ["campaign_billing.id"],
            name=op.f("fk_campaign_billing_id_campaign_billing"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_campaign")),
    )
    op.create_table(
        "action_download_app",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("title", sa.UnicodeText(), nullable=True),
        sa.Column("google_play_id", sa.UnicodeText(), nullable=True),
        sa.Column("app_store_id", sa.UnicodeText(), nullable=True),
        sa.Column("url", sa.UnicodeText(), nullable=False),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_action_download_app_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "action_open_site",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("title", sa.UnicodeText(), nullable=True),
        sa.Column("url", sa.UnicodeText(), nullable=False),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_action_open_site_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "action_phone_call",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("title", sa.UnicodeText(), nullable=True),
        sa.Column("phone", sa.UnicodeText(), nullable=False),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_action_phone_call_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "action_search",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("title", sa.UnicodeText(), nullable=True),
        sa.Column("organizations", sa.ARRAY(sa.BigInteger()), nullable=False),
        sa.Column("history_text", sa.UnicodeText(), nullable=False),
        sa.CheckConstraint(
            "0 < all(organizations)",
            name=op.f("ck_action_search_organizations_array_elements_positive"),
        ),
        sa.CheckConstraint(
            "cardinality(organizations) > 0",
            name=op.f("ck_action_search_organizations_not_empty_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_action_search_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "campaign_placing_area",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("areas", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("version", sa.BigInteger(), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(areas) = 'array'",
            name=op.f("ck_campaign_placing_area_areas_jsonb_array"),
        ),
        sa.CheckConstraint(
            "version >= 0", name=op.f("ck_campaign_placing_area_version_not_negative")
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaign_placing_area_campaign_id_campaign"),
        ),
        sa.UniqueConstraint(
            "campaign_id", name=op.f("uq_campaign_placing_area_campaign_id")
        ),
    )
    op.create_table(
        "campaign_placing_organizations",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("permalinks", sa.ARRAY(sa.BigInteger()), nullable=False),
        sa.CheckConstraint(
            "0 < all(permalinks)",
            name=op.f(
                "ck_campaign_placing_organizations_permalinks_array_elements_positive"
            ),
        ),
        sa.CheckConstraint(
            "cardinality(permalinks) > 0",
            name=op.f("ck_campaign_placing_organizations_permalinks_not_empty_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaign_placing_organizations_campaign_id_campaign"),
        ),
        sa.UniqueConstraint(
            "campaign_id", name=op.f("uq_campaign_placing_organizations_campaign_id")
        ),
    )
    op.create_table(
        "campaign_week_schedule",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("start", sa.Integer(), nullable=False),
        sa.Column("end", sa.Integer(), nullable=False),
        sa.CheckConstraint(
            '"end" <= 10080', name=op.f('ck_campaign_week_schedule_"end"_le_10080')
        ),
        sa.CheckConstraint(
            '"end" >= 0', name=op.f('ck_campaign_week_schedule_"end"_not_negative')
        ),
        sa.CheckConstraint(
            'start < "end"', name=op.f('ck_campaign_week_schedule_start_lt_"end"')
        ),
        sa.CheckConstraint(
            "start <= 10080", name=op.f("ck_campaign_week_schedule_start_le_10080")
        ),
        sa.CheckConstraint(
            "start >= 0", name=op.f("ck_campaign_week_schedule_start_not_negative")
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaign_week_schedule_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "creative_banner",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("disclaimer", sa.UnicodeText(), nullable=False),
        sa.Column("show_ads_label", sa.Boolean(), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_banner_images_jsonb_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_banner_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "creative_billboard",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_billboard_images_jsonb_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_billboard_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "creative_icon",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("text", sa.UnicodeText(), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_icon_images_jsonb_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_icon_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "creative_pin",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("title", sa.UnicodeText(), nullable=False),
        sa.Column("subtitle", sa.UnicodeText(), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_pin_images_jsonb_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_pin_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "creative_text",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("text", sa.UnicodeText(), nullable=False),
        sa.Column("disclaimer", sa.UnicodeText(), nullable=False),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_text_campaign_id_campaign"),
        ),
    )
    op.create_table(
        "status_history",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("author_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "status",
            sa.Enum(
                "ACTIVE",
                "ARCHIVED",
                "DONE",
                "DRAFT",
                "PAUSED",
                "REJECTED",
                "REVIEW",
                name="campaignstatusenum",
            ),
            nullable=False,
        ),
        sa.Column(
            "metadata",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default="{}",
            nullable=False,
        ),
        sa.Column(
            "changed_datetime",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.CheckConstraint(
            "jsonb_typeof(metadata) = 'object'",
            name=op.f("ck_status_history_metadata_jsonb_object"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_status_history_campaign_id_campaign"),
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("status_history")
    op.drop_table("creative_text")
    op.drop_table("creative_pin")
    op.drop_table("creative_icon")
    op.drop_table("creative_billboard")
    op.drop_table("creative_banner")
    op.drop_table("campaign_week_schedule")
    op.drop_table("campaign_placing_organizations")
    op.drop_table("campaign_placing_area")
    op.drop_table("action_search")
    op.drop_table("action_phone_call")
    op.drop_table("action_open_site")
    op.drop_table("action_download_app")
    op.drop_table("campaign")
    op.drop_table("campaign_billing")
    op.drop_table("billing_fix")
    op.drop_table("billing_cpm")
    op.drop_table("billing_cpa")
    op.execute(
        """
        DROP TYPE publicationenvenum;
        DROP TYPE campaigntypeenum;
        DROP TYPE campaignstatusenum;
        DROP TYPE platformenum;
        DROP TYPE fixtimeintervalenum;
        """
    )
    # ### end Alembic commands ###
