"""empty message

Revision ID: 48979a926943
Revises: d00960aee998
Create Date: 2019-09-25 17:54:09.796331

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "48979a926943"
down_revision = "d00960aee998"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "creative_pin_search",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("title", sa.UnicodeText(), nullable=False),
        sa.Column("organizations", sa.ARRAY(sa.BigInteger()), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_pin_search_images_jsonb_array"),
        ),
        sa.CheckConstraint(
            "0 < all(organizations)",
            name=op.f("ck_creative_pin_search_organizations_array_elements_positive"),
        ),
        sa.CheckConstraint(
            "cardinality(organizations) > 0",
            name=op.f("ck_creative_pin_search_organizations_not_empty_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_pin_search_campaign_id_campaign"),
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("creative_pin_search")
    # ### end Alembic commands ###
