"""add rubric column to campaign

Revision ID: be54b1485701
Revises: 0a463754c386
Create Date: 2019-10-18 15:46:04.167220

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "be54b1485701"
down_revision = "0a463754c386"
branch_labels = None
depends_on = None

enum_values = ("COMMON", "AUTO", "REALTY")
enum_type = sa.Enum(*enum_values, name="rubricenum")


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    enum_type.create(op.get_bind(), checkfirst=False)
    op.add_column("campaign", sa.Column("rubric", enum_type, nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("campaign", "rubric")
    enum_type.drop(op.get_bind(), checkfirst=False)
    # ### end Alembic commands ###
