"""empty message

Revision ID: c5520269a95f
Revises: 236374050c44
Create Date: 2019-11-18 14:46:29.715267

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c5520269a95f"
down_revision = "236374050c44"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "campaign", sa.Column("manul_order_id", sa.BigInteger(), nullable=True)
    )
    op.create_index(
        "campaign_manul_order_id_is_null",
        "campaign",
        ["manul_order_id"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text("manul_order_id IS NULL"),
    )
    op.create_check_constraint(
        op.f("ck_campaign_manul_order_id_not_negative"),
        "campaign",
        "manul_order_id >= 0",
    )
    op.create_check_constraint(
        op.f("ck_campaign_optional_one_of_order_id_manul_order_id"),
        "campaign",
        "(order_id is not null)::integer + (manul_order_id is not null)::integer < 2",
    ),
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "ck_campaign_optional_one_of_order_id_manul_order_id", "campaign"
    )
    op.drop_constraint("ck_campaign_manul_order_id_not_negative", "campaign")
    op.drop_index("campaign_manul_order_id_is_null", table_name="campaign")
    op.drop_column("campaign", "manul_order_id")
    # ### end Alembic commands ###
