"""empty message

Revision ID: d1a93d5038f8
Revises: c5520269a95f
Create Date: 2019-11-19 13:28:19.006409

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

import maps_adv.adv_store.v2.lib.db.columns
import maps_adv.adv_store.v2.lib.db.constraints

# revision identifiers, used by Alembic.
revision = "d1a93d5038f8"
down_revision = "c5520269a95f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "campaigns_activity_log",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column(
            "created_at",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("author_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "status",
            postgresql.ENUM(
                "ACTIVE",
                "ARCHIVED",
                "DONE",
                "DRAFT",
                "PAUSED",
                "REJECTED",
                "REVIEW",
                name="campaignstatusenum",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column(
            "daily_budget_reached_due_to",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            nullable=True,
        ),
        sa.Column(
            "daily_budget_reached_value",
            sa.Numeric(precision=18, scale=4),
            nullable=True,
        ),
        sa.Column(
            "budget_reached_value", sa.Numeric(precision=18, scale=4), nullable=True
        ),
        sa.Column("order_limit_reached", sa.Boolean(), nullable=False),
        sa.Column(
            "metadata",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default="{}",
            nullable=False,
        ),
        sa.Column(
            "system_metadata",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default="{}",
            nullable=False,
        ),
        sa.Column("is_latest", sa.Boolean(), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(metadata) = 'object'",
            name=op.f("ck_campaigns_activity_log_metadata_jsonb_object"),
        ),
        sa.CheckConstraint(
            "jsonb_typeof(system_metadata) = 'object'",
            name=op.f("ck_campaigns_activity_log_system_metadata_jsonb_object"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaigns_activity_log_campaign_id_campaign"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_campaigns_activity_log")),
    )
    op.create_index(
        "campaign_id_hash_partial_is_latest",
        "campaigns_activity_log",
        ["campaign_id"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text("is_latest"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "campaign_id_hash_partial_is_latest", table_name="campaigns_activity_log"
    )
    op.drop_table("campaigns_activity_log")
    # ### end Alembic commands ###
