"""empty message

Revision ID: 4941d9ac4bb6
Revises: d1a93d5038f8
Create Date: 2019-11-20 18:30:18.540120

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "4941d9ac4bb6"
down_revision = "d1a93d5038f8"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "creative_via_point",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("button_text_active", sa.UnicodeText(), nullable=False),
        sa.Column("button_text_inactive", sa.UnicodeText(), nullable=False),
        sa.Column("description", sa.UnicodeText(), nullable=False),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_via_point_images_jsonb_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_via_point_campaign_id_campaign"),
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("creative_via_point")
    # ### end Alembic commands ###
