"""empty message

Revision ID: f2fdea77a1d7
Revises: e82382b1075a
Create Date: 2019-12-06 15:39:53.282449

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "f2fdea77a1d7"
down_revision = "e82382b1075a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        "action_download_app_campaign_id",
        "action_download_app",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "action_open_site_campaign_id",
        "action_open_site",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "action_phone_call_campaign_id",
        "action_phone_call",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "action_search_campaign_id",
        "action_search",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "campaign_week_schedule_campaign_id",
        "campaign_week_schedule",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_banner_campaign_id",
        "creative_banner",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_billboard_campaign_id",
        "creative_billboard",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_icon_campaign_id",
        "creative_icon",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_logo_and_text_campaign_id",
        "creative_logo_and_text",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_pin_campaign_id",
        "creative_pin",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_pin_search_campaign_id",
        "creative_pin_search",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_text_campaign_id",
        "creative_text",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "creative_via_point_campaign_id",
        "creative_via_point",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "status_history_campaign_changed_datetime",
        "status_history",
        [sa.text("campaign_id DESC"), sa.text("changed_datetime DESC")],
        unique=False,
        postgresql_using="btree",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "status_history_campaign_changed_datetime", table_name="status_history"
    )
    op.drop_index("creative_via_point_campaign_id", table_name="creative_via_point")
    op.drop_index("creative_text_campaign_id", table_name="creative_text")
    op.drop_index("creative_pin_search_campaign_id", table_name="creative_pin_search")
    op.drop_index("creative_pin_campaign_id", table_name="creative_pin")
    op.drop_index(
        "creative_logo_and_text_campaign_id", table_name="creative_logo_and_text"
    )
    op.drop_index("creative_icon_campaign_id", table_name="creative_icon")
    op.drop_index("creative_billboard_campaign_id", table_name="creative_billboard")
    op.drop_index("creative_banner_campaign_id", table_name="creative_banner")
    op.drop_index(
        "campaign_week_schedule_campaign_id", table_name="campaign_week_schedule"
    )
    op.drop_index("action_search_campaign_id", table_name="action_search")
    op.drop_index("action_phone_call_campaign_id", table_name="action_phone_call")
    op.drop_index("action_open_site_campaign_id", table_name="action_open_site")
    op.drop_index("action_download_app_campaign_id", table_name="action_download_app")
    # ### end Alembic commands ###
