"""empty message

Revision ID: 7a5a058d666d
Revises: f2fdea77a1d7
Create Date: 2019-12-13 13:16:20.909063

"""
import sqlalchemy as sa
from alembic import op

import maps_adv.adv_store.v2.lib.db.columns
import maps_adv.adv_store.v2.lib.db.constraints

# revision identifiers, used by Alembic.
revision = "7a5a058d666d"
down_revision = "f2fdea77a1d7"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "campaign_discounts",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "start_datetime",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column(
            "end_datetime",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column("cost_multiplier", sa.Numeric(precision=8, scale=4), nullable=False),
        sa.CheckConstraint(
            "start_datetime < end_datetime",
            name=op.f("ck_campaign_discounts_start_datetime_lt_end_datetime"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaign_discounts_campaign_id_campaign"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_campaign_discounts")),
    )
    op.create_index(
        "campaign_discounts_campaign_id",
        "campaign_discounts",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("campaign_discounts_campaign_id", table_name="campaign_discounts")
    op.drop_table("campaign_discounts")
    # ### end Alembic commands ###
