"""Campaign event table

Revision ID: f7d8f0f60c06
Revises: fd21a4af044c
Create Date: 2020-05-12 15:58:38.182355

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

import maps_adv.adv_store.v2.lib.db.columns
import maps_adv.adv_store.v2.lib.db.constraints

# revision identifiers, used by Alembic.
revision = "f7d8f0f60c06"
down_revision = "fd21a4af044c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "campaign_event",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column(
            "timestamp",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "event_type",
            sa.Enum(
                "END_DATE_CHANGED",
                "STOPPED_MANUALLY",
                "STOPPED_BUDGET_REACHED",
                "BUDGET_DECREASED",
                name="campaigneventtype",
            ),
            nullable=False,
        ),
        sa.Column(
            "event_data", postgresql.JSONB(astext_type=sa.Text()), nullable=False
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_campaign_event")),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaign_event_campaign_id_campaign"),
        ),
        sa.CheckConstraint(
            "jsonb_typeof(event_data) = 'object'",
            name=op.f("ck_campaign_event_data_jsonb_object"),
        ),
    )
    op.create_index(
        "campaign_event_timestamp", "campaign_event", ["timestamp"], unique=False
    )
    op.create_index(
        "campaign_event_campaign_id",
        "campaign_event",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("campaign_event_timestamp", table_name="campaign_event")
    op.drop_index("campaign_event_campaign_id", table_name="campaign_event")
    op.drop_table("campaign_event")
    op.execute(
        """
            DROP TYPE campaigneventtype;
            """
    )
    # ### end Alembic commands ###
