"""Campaign event type - add CAMPAIGN_NOT_SPENDING_BUDGET

Revision ID: 72a614cf3477
Revises: f7d8f0f60c06
Create Date: 2020-05-20 18:21:28.371275

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = "72a614cf3477"
down_revision = "33421e19542d"
branch_labels = None
depends_on = None


def upgrade():
    op.execute(
        """
        ALTER TABLE campaign_event
        ALTER COLUMN event_type
        TYPE varchar(255)
        """
    )
    op.execute("DROP TYPE IF EXISTS campaigneventtype")
    op.execute(
        """
        CREATE TYPE campaigneventtype AS ENUM (
            'END_DATE_CHANGED',
            'STOPPED_MANUALLY',
            'STOPPED_BUDGET_REACHED',
            'BUDGET_DECREASED',
            'NOT_SPENDING_BUDGET'
        )
        """
    )
    op.execute(
        """
        ALTER TABLE campaign_event
        ALTER COLUMN event_type
        TYPE campaigneventtype
        USING (event_type::campaigneventtype);
        """
    )


def downgrade():
    op.execute("DELETE FROM campaign_event WHERE event_type = 'NOT_SPENDING_BUDGET';")
    op.execute(
        """
            ALTER TABLE campaign_event
            ALTER COLUMN event_type
            TYPE varchar(255)
        """
    )
    op.execute("DROP TYPE IF EXISTS campaigneventtype")
    op.execute(
        """
            CREATE TYPE campaigneventtype AS ENUM (
                'END_DATE_CHANGED',
                'STOPPED_MANUALLY',
                'STOPPED_BUDGET_REACHED',
                'BUDGET_DECREASED'
            )
        """
    )
    op.execute(
        """
            ALTER TABLE campaign_event
            ALTER COLUMN event_type
            TYPE campaigneventtype
            USING (event_type::campaigneventtype);
        """
    )
