"""Direct moderation table

Revision ID: a8dcc4b2c33f
Revises: 72a614cf3477
Create Date: 2020-06-04 15:25:25.331974

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy import ForeignKey
from sqlalchemy.dialects import postgresql

import maps_adv.adv_store.v2.lib.db.columns
import maps_adv.adv_store.v2.lib.db.constraints

# revision identifiers, used by Alembic.
revision = "a8dcc4b2c33f"
down_revision = "72a614cf3477"
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "campaign_direct_moderation",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column(
            "created_at",
            maps_adv.adv_store.v2.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("reviewer_uid", sa.BigInteger(), nullable=True),
        sa.Column(
            "status",
            sa.Enum(
                "NEW",
                "PROCESSING",
                "ACCEPTED",
                "REJECTED",
                "OUTDATED",
                name="campaigndirectmoderationstatus",
            ),
            nullable=False,
        ),
        sa.Column(
            "workflow",
            sa.Enum(
                "COMMON",
                "AUTO_ACCEPT",
                "AUTO_REJECT",
                "MANUAL_ONLY",
                name="campaigndirectmoderationworkflow",
            ),
            nullable=False,
        ),
        sa.Column("verdicts", postgresql.ARRAY(sa.BigInteger()), nullable=False),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_campaigns_direct_moderation_campaign_id_campaign"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_campaign_direct_moderation")),
    )
    op.create_index(
        "ix_campaign_direct_moderation_campaign_id",
        "campaign_direct_moderation",
        ["campaign_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_index(
        "ix_campaign_direct_moderation_status",
        "campaign_direct_moderation",
        ["status"],
        unique=False,
        postgresql_using="hash",
    )
    op.add_column(
        "campaign",
        sa.Column(
            "direct_moderation_id",
            sa.BigInteger(),
            ForeignKey("campaign_direct_moderation.id"),
            nullable=True,
        ),
    )


def downgrade():
    op.drop_column("campaign", "direct_moderation_id")
    op.drop_index(
        "ix_campaign_direct_moderation_status", table_name="campaign_direct_moderation"
    )
    op.drop_index(
        "ix_campaign_direct_moderation_campaign_id",
        table_name="campaign_direct_moderation",
    )
    op.drop_table("campaign_direct_moderation")
    op.execute(
        """
            DROP TYPE campaigndirectmoderationstatus;
            """
    )
    op.execute(
        """
            DROP TYPE campaigndirectmoderationworkflow;
            """
    )
