"""New creative table

Revision ID: 8bb0d2e95764
Revises: a8dcc4b2c33f
Create Date: 2020-06-18 13:03:35.497337

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "8bb0d2e95764"
down_revision = "a8dcc4b2c33f"
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "creative_audio_banner",
        sa.Column("campaign_id", sa.BigInteger(), nullable=False),
        sa.Column("images", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("left_anchor", sa.Numeric(precision=7, scale=6), nullable=False),
        sa.Column("audio_file_url", sa.UnicodeText(), nullable=False),
        sa.CheckConstraint(
            "left_anchor > 0",
            name=op.f("ck_campaign_audio_banner_left_anchor_positive"),
        ),
        sa.CheckConstraint(
            "left_anchor <= 1", name=op.f("ck_campaign_audio_banner_left_anchor_le_1")
        ),
        sa.CheckConstraint(
            "jsonb_typeof(images) = 'array'",
            name=op.f("ck_creative_audio_banner_images_jsonb_array"),
        ),
        sa.ForeignKeyConstraint(
            ["campaign_id"],
            ["campaign.id"],
            name=op.f("fk_creative_audio_banner_campaign_id_campaign"),
        ),
    )


def downgrade():
    op.drop_table("creative_audio_banner")
