"""change left_anchor constraint

Revision ID: 6de625348a53
Revises: 5d40824b96f6
Create Date: 2020-07-14 19:24:19.562703

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = "6de625348a53"
down_revision = "5d40824b96f6"
branch_labels = None
depends_on = None


def upgrade():
    op.drop_constraint(
        "ck_campaign_audio_banner_left_anchor_positive", "creative_audio_banner"
    )
    op.create_check_constraint(
        op.f("ck_campaign_audio_banner_left_anchor_not_negative"),
        "creative_audio_banner",
        "left_anchor >= 0",
    )


def downgrade():
    op.drop_constraint(
        "ck_campaign_audio_banner_left_anchor_not_negative", "creative_audio_banner"
    )
    op.create_check_constraint(
        op.f("ck_campaign_audio_banner_left_anchor_positive"),
        "creative_audio_banner",
        "left_anchor > 0",
    )
