"""Add settings column to campaigns table

Revision ID: ec0ef9de47aa
Revises: 2c7e89f16d10
Create Date: 2020-11-02 15:00:45.248825

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "ec0ef9de47aa"
down_revision = "2c7e89f16d10"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        "campaign",
        sa.Column(
            "settings",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default="{}",
            nullable=False,
        ),
    )


def downgrade():
    op.drop_column("campaign", "settings")
