"""Add main field to all actions

Revision ID: 1c803458de12
Revises: ec0ef9de47aa
Create Date: 2020-11-23 13:03:30.804652

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "1c803458de12"
down_revision = "ec0ef9de47aa"
branch_labels = None
depends_on = None


def upgrade():
    op.add_column(
        "action_download_app",
        sa.Column("main", sa.Boolean(), server_default="FALSE", nullable=False),
    )
    op.add_column(
        "action_open_site",
        sa.Column("main", sa.Boolean(), server_default="FALSE", nullable=False),
    )
    op.add_column(
        "action_phone_call",
        sa.Column("main", sa.Boolean(), server_default="FALSE", nullable=False),
    )
    op.add_column(
        "action_promocode",
        sa.Column("main", sa.Boolean(), server_default="FALSE", nullable=False),
    )
    op.add_column(
        "action_resolve_uri",
        sa.Column("main", sa.Boolean(), server_default="FALSE", nullable=False),
    )
    op.add_column(
        "action_search",
        sa.Column("main", sa.Boolean(), server_default="FALSE", nullable=False),
    )
    op.execute(
        """
CREATE OR REPLACE VIEW campaigns_full_state_view AS (
    SELECT
        campaign.id AS id,
        to_jsonb(campaign) - 'billing_id' AS campaign,
        jsonb_build_object(
            'id', campaign_billing.id,
            'cpm', json_build_object(
                'id', billing_cpm.id,
                    'cost', billing_cpm.cost::text,
                    'budget', billing_cpm.budget::text,
                    'daily_budget', billing_cpm.daily_budget::text,
                    'auto_daily_budget', billing_cpm.auto_daily_budget
                ),
                'cpa', json_build_object(
                    'id', billing_cpa.id,
                    'cost', billing_cpa.cost::text,
                    'budget', billing_cpa.budget::text,
                    'daily_budget', billing_cpa.daily_budget::text,
                    'auto_daily_budget', billing_cpa.auto_daily_budget
                ),
                'fix', json_build_object(
                    'id', billing_fix.id,
                    'time_interval', billing_fix.time_interval,
                    'cost', billing_fix.cost::text
                )
        ) AS billing,
        jsonb_build_object(
            'area', to_jsonb(campaign_placing_area)  - 'campaign_id',
            'organizations', to_jsonb(campaign_placing_organizations)  - 'campaign_id'
        ) AS "placing",

        (  -- Week schedule
            SELECT jsonb_agg(to_jsonb(week_schedule_subq) - 'campaign_id')
            FROM (
                SELECT *
                FROM campaign_week_schedule
                WHERE campaign_id = campaign.id
                ORDER BY campaign_week_schedule.start, campaign_week_schedule.end
            ) as week_schedule_subq
        ) AS week_schedule,

        (  -- Discounts
            SELECT jsonb_agg(to_jsonb(campaign_discounts_subq) - 'campaign_id')
            FROM (
                SELECT *
                FROM campaign_discounts
                WHERE campaign_id = campaign.id
                ORDER BY
                    campaign_discounts.start_datetime,
                    campaign_discounts.end_datetime
            ) as campaign_discounts_subq
        ) AS discounts,

        -- Last status history for campaign
        (
            SELECT to_jsonb(status_history) - 'campaign_id'
            FROM status_history
            WHERE campaign_id = campaign.id
            ORDER BY changed_datetime DESC
            LIMIT 1
        ) AS current_status_history,

        -- Actions
        jsonb_build_object(
            'download_app', (
                SELECT jsonb_agg(to_jsonb(action_download_app_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_download_app
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_download_app.title,
                        action_download_app.url,
                        action_download_app.google_play_id,
                        action_download_app.app_store_id,
                        action_download_app.main
                ) as action_download_app_subq
            ),
            'open_site', (
                SELECT jsonb_agg(to_jsonb(action_open_site_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_open_site
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_open_site.title,
                        action_open_site.url,
                        action_open_site.main
                ) as action_open_site_subq
            ),
            'phone_call', (
                SELECT jsonb_agg(to_jsonb(action_phone_call_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_phone_call
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_phone_call.title,
                        action_phone_call.phone,
                        action_phone_call.main
                ) as action_phone_call_subq
            ),
            'promocode', (
                SELECT jsonb_agg(to_jsonb(action_promocode_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_promocode
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_promocode.promocode,
                        action_promocode.main
                ) as action_promocode_subq
            ),
            'search', (
                SELECT jsonb_agg(to_jsonb(action_search_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_search
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_search.title,
                        action_search.history_text,
                        action_search.main
                ) as action_search_subq
            ),
            'resolve_uri', (
                SELECT jsonb_agg(to_jsonb(action_resolve_uri_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_resolve_uri
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_resolve_uri.uri,
                        action_resolve_uri.action_type,
                        action_resolve_uri.target,
                        action_resolve_uri.dialog,
                        action_resolve_uri.main
                ) as action_resolve_uri_subq
            )
        ) AS action,

        -- Creatives
        jsonb_build_object(
            'banner', (
                SELECT jsonb_agg(to_jsonb(creative_banner_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_banner
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        creative_banner.title,
                        creative_banner.description,
                        creative_banner.disclaimer,
                        creative_banner.terms
                ) as creative_banner_subq
            ),
            'billboard', (
                SELECT jsonb_agg(to_jsonb(creative_billboard_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_billboard
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_billboard.images
                ) as creative_billboard_subq
            ),
            'icon', (
                SELECT jsonb_agg(to_jsonb(creative_icon_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_icon
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_icon.position, creative_icon.title
                ) as creative_icon_subq
            ),
            'logo_and_text', (
                SELECT jsonb_agg(to_jsonb(creative_logo_and_text_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_logo_and_text
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_logo_and_text.text
                ) as creative_logo_and_text_subq
            ),
            'pin', (
                SELECT jsonb_agg(to_jsonb(creative_pin_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_pin
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_pin.title, creative_pin.subtitle
                ) AS creative_pin_subq
            ),
            'pin_search', (
                SELECT jsonb_agg(to_jsonb(creative_pin_search_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_pin_search
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_pin_search.title
                ) AS creative_pin_search_subq
            ),
            'text', (
                SELECT jsonb_agg(to_jsonb(creative_text_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_text
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_text.text, creative_text.disclaimer
                ) AS creative_text_subq
            ),
            'via_point', (
                SELECT jsonb_agg(to_jsonb(creative_via_point_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_via_point
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        creative_via_point.button_text_active,
                        creative_via_point.button_text_inactive,
                        creative_via_point.description
                ) AS creative_via_point_subq
            ),
            'audio_banner', (
                SELECT jsonb_agg(to_jsonb(creative_audio_banner_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_audio_banner
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        creative_audio_banner.audio_file_url,
                        creative_audio_banner.left_anchor
                ) AS creative_audio_banner_subq
            )
        ) AS creative

    FROM campaign
        LEFT JOIN campaign_billing ON campaign.billing_id = campaign_billing.id

        -- Billing
        LEFT JOIN billing_cpm ON campaign_billing.cpm_id = billing_cpm.id
        LEFT JOIN billing_cpa ON campaign_billing.cpa_id = billing_cpa.id
        LEFT JOIN billing_fix ON campaign_billing.fix_id = billing_fix.id

        -- Placing
        LEFT JOIN campaign_placing_area ON campaign_placing_area.campaign_id = campaign.id
        LEFT JOIN campaign_placing_organizations ON campaign_placing_organizations.campaign_id = campaign.id
)
        """  # noqa: E501
    )


def downgrade():
    op.execute("DROP VIEW campaigns_full_state_view")
    op.drop_column("action_search", "main")
    op.drop_column("action_resolve_uri", "main")
    op.drop_column("action_promocode", "main")
    op.drop_column("action_phone_call", "main")
    op.drop_column("action_open_site", "main")
    op.drop_column("action_download_app", "main")
    op.execute(
        """
CREATE OR REPLACE VIEW campaigns_full_state_view AS (
    SELECT
        campaign.id AS id,
        to_jsonb(campaign) - 'billing_id' AS campaign,
        jsonb_build_object(
            'id', campaign_billing.id,
            'cpm', json_build_object(
                'id', billing_cpm.id,
                    'cost', billing_cpm.cost::text,
                    'budget', billing_cpm.budget::text,
                    'daily_budget', billing_cpm.daily_budget::text,
                    'auto_daily_budget', billing_cpm.auto_daily_budget
                ),
                'cpa', json_build_object(
                    'id', billing_cpa.id,
                    'cost', billing_cpa.cost::text,
                    'budget', billing_cpa.budget::text,
                    'daily_budget', billing_cpa.daily_budget::text,
                    'auto_daily_budget', billing_cpa.auto_daily_budget
                ),
                'fix', json_build_object(
                    'id', billing_fix.id,
                    'time_interval', billing_fix.time_interval,
                    'cost', billing_fix.cost::text
                )
        ) AS billing,
        jsonb_build_object(
            'area', to_jsonb(campaign_placing_area)  - 'campaign_id',
            'organizations', to_jsonb(campaign_placing_organizations)  - 'campaign_id'
        ) AS "placing",

        (  -- Week schedule
            SELECT jsonb_agg(to_jsonb(week_schedule_subq) - 'campaign_id')
            FROM (
                SELECT *
                FROM campaign_week_schedule
                WHERE campaign_id = campaign.id
                ORDER BY campaign_week_schedule.start, campaign_week_schedule.end
            ) as week_schedule_subq
        ) AS week_schedule,

        (  -- Discounts
            SELECT jsonb_agg(to_jsonb(campaign_discounts_subq) - 'campaign_id')
            FROM (
                SELECT *
                FROM campaign_discounts
                WHERE campaign_id = campaign.id
                ORDER BY
                    campaign_discounts.start_datetime,
                    campaign_discounts.end_datetime
            ) as campaign_discounts_subq
        ) AS discounts,

        -- Last status history for campaign
        (
            SELECT to_jsonb(status_history) - 'campaign_id'
            FROM status_history
            WHERE campaign_id = campaign.id
            ORDER BY changed_datetime DESC
            LIMIT 1
        ) AS current_status_history,

        -- Actions
        jsonb_build_object(
            'download_app', (
                SELECT jsonb_agg(to_jsonb(action_download_app_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_download_app
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_download_app.title,
                        action_download_app.url,
                        action_download_app.google_play_id,
                        action_download_app.app_store_id
                ) as action_download_app_subq
            ),
            'open_site', (
                SELECT jsonb_agg(to_jsonb(action_open_site_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_open_site
                    WHERE campaign_id = campaign.id
                    ORDER BY action_open_site.title, action_open_site.url
                ) as action_open_site_subq
            ),
            'phone_call', (
                SELECT jsonb_agg(to_jsonb(action_phone_call_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_phone_call
                    WHERE campaign_id = campaign.id
                    ORDER BY action_phone_call.title, action_phone_call.phone
                ) as action_phone_call_subq
            ),
            'promocode', (
                SELECT jsonb_agg(to_jsonb(action_promocode_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_promocode
                    WHERE campaign_id = campaign.id
                    ORDER BY action_promocode.promocode
                ) as action_promocode_subq
            ),
            'search', (
                SELECT jsonb_agg(to_jsonb(action_search_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_search
                    WHERE campaign_id = campaign.id
                    ORDER BY action_search.title, action_search.history_text
                ) as action_search_subq
            ),
            'resolve_uri', (
                SELECT jsonb_agg(to_jsonb(action_resolve_uri_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM action_resolve_uri
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        action_resolve_uri.uri,
                        action_resolve_uri.action_type,
                        action_resolve_uri.target,
                        action_resolve_uri.dialog
                ) as action_resolve_uri_subq
            )
        ) AS action,

        -- Creatives
        jsonb_build_object(
            'banner', (
                SELECT jsonb_agg(to_jsonb(creative_banner_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_banner
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        creative_banner.title,
                        creative_banner.description,
                        creative_banner.disclaimer,
                        creative_banner.terms
                ) as creative_banner_subq
            ),
            'billboard', (
                SELECT jsonb_agg(to_jsonb(creative_billboard_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_billboard
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_billboard.images
                ) as creative_billboard_subq
            ),
            'icon', (
                SELECT jsonb_agg(to_jsonb(creative_icon_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_icon
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_icon.position, creative_icon.title
                ) as creative_icon_subq
            ),
            'logo_and_text', (
                SELECT jsonb_agg(to_jsonb(creative_logo_and_text_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_logo_and_text
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_logo_and_text.text
                ) as creative_logo_and_text_subq
            ),
            'pin', (
                SELECT jsonb_agg(to_jsonb(creative_pin_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_pin
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_pin.title, creative_pin.subtitle
                ) AS creative_pin_subq
            ),
            'pin_search', (
                SELECT jsonb_agg(to_jsonb(creative_pin_search_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_pin_search
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_pin_search.title
                ) AS creative_pin_search_subq
            ),
            'text', (
                SELECT jsonb_agg(to_jsonb(creative_text_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_text
                    WHERE campaign_id = campaign.id
                    ORDER BY creative_text.text, creative_text.disclaimer
                ) AS creative_text_subq
            ),
            'via_point', (
                SELECT jsonb_agg(to_jsonb(creative_via_point_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_via_point
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        creative_via_point.button_text_active,
                        creative_via_point.button_text_inactive,
                        creative_via_point.description
                ) AS creative_via_point_subq
            ),
            'audio_banner', (
                SELECT jsonb_agg(to_jsonb(creative_audio_banner_subq) - 'campaign_id')
                FROM (
                    SELECT *
                    FROM creative_audio_banner
                    WHERE campaign_id = campaign.id
                    ORDER BY
                        creative_audio_banner.audio_file_url,
                        creative_audio_banner.left_anchor
                ) AS creative_audio_banner_subq
            )
        ) AS creative

    FROM campaign
        LEFT JOIN campaign_billing ON campaign.billing_id = campaign_billing.id

        -- Billing
        LEFT JOIN billing_cpm ON campaign_billing.cpm_id = billing_cpm.id
        LEFT JOIN billing_cpa ON campaign_billing.cpa_id = billing_cpa.id
        LEFT JOIN billing_fix ON campaign_billing.fix_id = billing_fix.id

        -- Placing
        LEFT JOIN campaign_placing_area ON campaign_placing_area.campaign_id = campaign.id
        LEFT JOIN campaign_placing_organizations ON campaign_placing_organizations.campaign_id = campaign.id
)
        """  # noqa: E501
    )
