PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    maps_adv/adv_store/v2

    maps_adv/common/helpers

    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock
)

SRCDIR(
    maps_adv/adv_store/v2
)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/campaigns/__init__.py
    api/moderation/__init__.py
    conftest.py
    data_managers/__init__.py
    data_managers/campaigns/__init__.py
    db/__init__.py
    dms.py
    factory.py
)

TEST_SRCS(
    api/campaigns/test_create_campaign.py
    api/campaigns/test_list_campaigns_for_budget_analysis.py
    api/campaigns/test_list_campaigns_for_charger.py
    api/campaigns/test_list_campaigns_for_charger_cpa.py
    api/campaigns/test_list_campaigns_for_charger_fix.py
    api/campaigns/test_list_campaigns_for_export.py
    api/campaigns/test_list_campaigns_for_orders.py
    api/campaigns/test_list_campaigns_summary.py
    api/campaigns/test_list_short_campaigns.py
    api/campaigns/test_predict_daily_budget.py
    api/campaigns/test_retrieve_campaign.py
    api/campaigns/test_retrieve_campaign_data_for_monitorings.py
    api/campaigns/test_set_status.py
    api/campaigns/test_set_paid_till.py
    api/campaigns/test_stop_campaigns.py
    api/campaigns/test_update_campaign.py
    api/campaigns/test_list_used_audiences.py
    api/events/__init__.py
    api/events/test_retrieve_campaign_events_for_orders.py
    api/moderation/test_list.py
    api/moderation/test_review.py
    api/test_ping.py
    core/logbroker/__init__.py
    core/logbroker/test_client.py
    core/logbroker/test_reader.py
    core/logbroker/test_writer.py
    data_managers/campaigns/test_backup_campaigns_change_log.py
    core/direct_moderation/__init__.py
    core/direct_moderation/test_retrieve_direct_responses.py
    core/direct_moderation/test_send_moderation_data.py
    core/direct_moderation/test_zero_speed_data.py
    data_managers/campaigns/test_campaign_exists.py
    data_managers/campaigns/test_create_campaign.py
    data_managers/campaigns/test_list_campaigns_by_orders.py
    data_managers/campaigns/test_list_campaigns_for_budget_analysis.py
    data_managers/campaigns/test_list_campaigns_for_charger.py
    data_managers/campaigns/test_list_campaigns_for_charger_cpa.py
    data_managers/campaigns/test_list_campaigns_for_charger_fix.py
    data_managers/campaigns/test_list_campaigns_for_export.py
    data_managers/campaigns/test_list_campaigns_summary.py
    data_managers/campaigns/test_list_short_campaigns.py
    data_managers/campaigns/test_refresh_auto_daily_budgets.py
    data_managers/campaigns/test_refresh_campaigns_change_logs.py
    data_managers/campaigns/test_retrieve_campaign.py
    data_managers/campaigns/test_retrieve_campaign_data_for_monitorings.py
    data_managers/campaigns/test_set_status.py
    data_managers/campaigns/test_update_campaign.py
    data_managers/campaigns/test_retrieve_existing_campaign_ids.py
    data_managers/campaigns/test_stop_campaigns.py
    data_managers/campaigns/test_retrieve_targetings.py
    data_managers/campaigns/test_set_paid_till.py
    data_managers/events/__init__.py
    data_managers/events/test_create_campaign_event.py
    data_managers/events/test_create_event_budget_decreased.py
    data_managers/events/test_create_event_end_datetime_changed.py
    data_managers/events/test_create_event_stopped_manually.py
    data_managers/events/test_create_events_for_campaigns.py
    data_managers/events/test_create_events_stopped_budget_reached.py
    data_managers/events/test_retrieve_campaign_events_for_orders.py
    data_managers/moderation/test_list.py
    data_managers/moderation/test_create_moderation_for_campaign.py
    data_managers/moderation/test_retrieve_moderations_by_status.py
    data_managers/moderation/test_retrieve_direct_moderation.py
    data_managers/moderation/test_update_direct_moderation.py
    db/test_campaigns_full_state_view.py
    db/test_healthcheck.py
    domains/__init__.py
    domains/campaigns/__init__.py
    domains/campaigns/test_backup_campaigns_change_log.py
    domains/campaigns/test_create_campaign.py
    domains/campaigns/test_list_campaigns_for_charger_cpa.py
    domains/campaigns/test_predict_daily_budget.py
    domains/campaigns/test_refresh_auto_daily_budgets.py
    domains/campaigns/test_set_status.py
    domains/campaigns/test_set_paid_till.py
    domains/campaigns/test_stop_campaigns.py
    domains/campaigns/test_update_campaign.py
    domains/campaigns/test_list_used_audiences.py
    domains/campaigns/test_retrieve_campaign_data_for_monitorings.py
    domains/events/__init__.py
    domains/events/test_create_campaign_events.py
    domains/events/test_retrieve_campaign_events_for_orders.py
    domains/moderation/__init__.py
    domains/moderation/test_list_campaigns.py
    domains/moderation/test_process_direct_moderation_responses.py
    domains/moderation/test_process_new_moderations.py
    domains/moderation/test_review_campaign.py
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

END()

