PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/protobuf
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/sqlalchemy/sqlalchemy-1.2  # transition; see https://st.yandex-team.ru/CONTRIB-2042
    contrib/python/asyncpg
    contrib/python/janus
    contrib/python/psycopg2
    kikimr/public/sdk/python/persqueue
    yt/python/client

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/adv_store/api/schemas
    maps_adv/common/helpers
    maps_adv/statistics/dashboard/client
    maps_adv/warden/client
    maps_adv/billing_proxy/client

    maps_adv/common/helpers
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/campaigns.py
    lib/api/events.py
    lib/api/middlewares.py
    lib/api/moderation.py
    lib/api/ping.py
    lib/api/api_providers/__init__.py
    lib/api/api_providers/base.py
    lib/api/api_providers/campaigns.py
    lib/api/api_providers/events.py
    lib/api/api_providers/moderation.py
    lib/core/__init__.py
    lib/core/logbroker.py
    lib/core/direct_moderation/__init__.py
    lib/core/direct_moderation/client.py
    lib/core/direct_moderation/schema.py
    lib/data_managers/__init__.py
    lib/data_managers/base.py
    lib/data_managers/campaigns.py
    lib/data_managers/events.py
    lib/data_managers/exceptions.py
    lib/data_managers/moderation.py
    lib/data_managers/sqls/__init__.py
    lib/data_managers/sqls/actions.py
    lib/data_managers/sqls/billing.py
    lib/data_managers/sqls/creatives.py
    lib/data_managers/sqls/discounts.py
    lib/data_managers/sqls/moderation.py
    lib/data_managers/sqls/placing.py
    lib/data_managers/sqls/week_schedules.py
    lib/data_managers/sqls/campaign/__init__.py
    lib/data_managers/sqls/campaign/listings.py
    lib/data_managers/sqls/campaign/single.py
    lib/data_managers/sqls/events.py
    lib/domains/__init__.py
    lib/domains/campaigns.py
    lib/domains/events.py
    lib/domains/moderation.py
    lib/db/__init__.py
    lib/db/columns.py
    lib/db/constraints.py
    lib/db/engine.py
    lib/db/tables.py
)

RESOURCE_FILES(
    PREFIX maps_adv/adv_store/v2/
    alembic.ini
    lib/db/migrations/env.py
    lib/db/migrations/script.py.mako
    lib/db/migrations/versions/20190823_1127_b6f36a974e99.py
    lib/db/migrations/versions/20190920_1303_d00960aee998.py
    lib/db/migrations/versions/20190925_1754_48979a926943.py
    lib/db/migrations/versions/20190927_1300_0f49d737992c.py
    lib/db/migrations/versions/20191003_2240_fa051dbebf79.py
    lib/db/migrations/versions/20191008_1619_0a463754c386.py
    lib/db/migrations/versions/20191018_1546_be54b1485701.py
    lib/db/migrations/versions/20191023_1341_3935f488fc9a.py
    lib/db/migrations/versions/20191023_2023_236374050c44.py
    lib/db/migrations/versions/20191118_1446_c5520269a95f.py
    lib/db/migrations/versions/20191119_1328_d1a93d5038f8.py
    lib/db/migrations/versions/20191120_1830_4941d9ac4bb6.py
    lib/db/migrations/versions/20191121_1750_e82382b1075a.py
    lib/db/migrations/versions/20191206_1539_f2fdea77a1d7.py
    lib/db/migrations/versions/20191213_1316_7a5a058d666d.py
    lib/db/migrations/versions/20200127_1929_8d3967062a0a.py
    lib/db/migrations/versions/20200130_1923_e7d3b54f0fa0.py
    lib/db/migrations/versions/20200206_1336_1212226327bb.py
    lib/db/migrations/versions/20200213_1917_93f86f4425ad.py
    lib/db/migrations/versions/20200408_2053_fd21a4af044c.py
    lib/db/migrations/versions/20200512_1558_f7d8f0f60c06.py
    lib/db/migrations/versions/20200514_1541_6c61b65786ce.py
    lib/db/migrations/versions/20200518_1016_33421e19542d.py
    lib/db/migrations/versions/20200520_1821_72a614cf3477.py
    lib/db/migrations/versions/20200604_1525_a8dcc4b2c33f.py
    lib/db/migrations/versions/20200618_1303_8bb0d2e95764.py
    lib/db/migrations/versions/20200622_1313_5d40824b96f6.py
    lib/db/migrations/versions/20200714_1924_6de625348a53.py
    lib/db/migrations/versions/20200814_1544_0514d4d80eaa.py
    lib/db/migrations/versions/20200911_1221_73f22b6ac6af.py
    lib/db/migrations/versions/20200928_1732_2c7e89f16d10.py
    lib/db/migrations/versions/20201102_1500_ec0ef9de47aa.py
    lib/db/migrations/versions/20201123_1303_1c803458de12.py
    lib/db/migrations/versions/20201202_1551_c4716a02b1c2.py
    lib/db/migrations/versions/20201211_1248_08b89b2f1e5d.py
    lib/db/migrations/versions/20220425_1551_d2f3d086e363.py
    lib/db/migrations/versions/20220606_1801_1a530a2590f8.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(app)
