PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/protobuf
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/databases
    contrib/python/jsonschema
    contrib/python/pytz
    yt/python/client

    yql/library/python

    smb/common/multiruntime

    maps_adv/adv_store/api/schemas
    maps_adv/adv_store/v2
    maps_adv/billing_proxy/proto
    maps_adv/config_loader
    maps_adv/common/helpers
    maps_adv/common/proto
    maps_adv/common/protomallow
    maps_adv/warden/client
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/resources/campaign.py
    lib/api/resources/system.py
    lib/api_provider/__init__.py
    lib/api_provider/campaign.py
    lib/api_provider/exceptions.py
    lib/application.py
    lib/config.py
    lib/data_managers/__init__.py
    lib/data_managers/campaign_change_log.py
    lib/data_managers/campaign_display_probability.py
    lib/data_managers/common.py
    lib/data_managers/create_campaign.py
    lib/data_managers/enums.py
    lib/data_managers/exceptions.py
    lib/data_managers/get_campaign.py
    lib/data_managers/status_history.py
    lib/data_managers/unstop_campaigns.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/domain/__init__.py
    lib/domain/campaign.py
    lib/domain/exceptions.py
    lib/domain/unstop_campaigns.py
    lib/domain/validators.py
    lib/schemas/__init__.py
    lib/schemas/base.py
    lib/task_executor.py
)

RESOURCE_FILES(
    PREFIX maps_adv/adv_store/
    alembic.ini
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    app
    v2
    client
)
