import argparse
import logging

from maps_adv.billing_proxy.lib import Application, config

parser = argparse.ArgumentParser("Billing proxy http server")
parser.add_argument("--host")
parser.add_argument("--port")


def main():
    logging.basicConfig(level=logging.DEBUG)
    args = parser.parse_args()

    config.init()
    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
