from enum import Enum, auto

from maps_adv.billing_proxy.proto.common_pb2 import CurrencyType
from maps_adv.billing_proxy.proto.products_pb2 import CpmCalculationInput


class Currency(Enum):
    RUB = auto()
    BYN = auto()
    TRY = auto()
    KZT = auto()
    EUR = auto()
    USD = auto()


class AdvRubric(Enum):
    COMMON = auto()
    AUTO = auto()
    REALTY = auto()


class CreativeType(Enum):
    BILLBOARD = auto()
    PIN = auto()
    BANNER = auto()
    TEXT = auto()
    ICON = auto()
    PIN_SEARCH = auto()
    LOGO_AND_TEXT = auto()
    VIA_POINT = auto()
    AUDIO_BANNER = auto()


class OrderSize(Enum):
    SMALL = auto()
    BIG = auto()
    VERY_BIG = auto()


ENUMS_MAP = {
    "currency": {
        CurrencyType.RUB: Currency.RUB,
        CurrencyType.BYN: Currency.BYN,
        CurrencyType.TRY: Currency.TRY,
        CurrencyType.KZT: Currency.KZT,
        CurrencyType.EUR: Currency.EUR,
        CurrencyType.USD: Currency.USD,
    },
    "creative_type": {
        CreativeType.BILLBOARD: CpmCalculationInput.CreativeType.BILLBOARD,
        CreativeType.PIN: CpmCalculationInput.CreativeType.PIN,
        CreativeType.BANNER: CpmCalculationInput.CreativeType.BANNER,
        CreativeType.TEXT: CpmCalculationInput.CreativeType.TEXT,
        CreativeType.ICON: CpmCalculationInput.CreativeType.ICON,
        CreativeType.PIN_SEARCH: CpmCalculationInput.CreativeType.PIN_SEARCH,
        CreativeType.LOGO_AND_TEXT: CpmCalculationInput.CreativeType.LOGO_AND_TEXT,
        CreativeType.VIA_POINT: CpmCalculationInput.CreativeType.VIA_POINT,
        CreativeType.AUDIO_BANNER: CpmCalculationInput.CreativeType.AUDIO_BANNER,
    },
    "order_size": {
        OrderSize.SMALL: CpmCalculationInput.OrderSize.SMALL,
        OrderSize.BIG: CpmCalculationInput.OrderSize.BIG,
        OrderSize.VERY_BIG: CpmCalculationInput.OrderSize.VERY_BIG,
    },
    "rubric": {
        AdvRubric.COMMON: CpmCalculationInput.AdvRubric.COMMON,
        AdvRubric.AUTO: CpmCalculationInput.AdvRubric.AUTO,
        AdvRubric.REALTY: CpmCalculationInput.AdvRubric.REALTY,
    },
}
