import enum

from maps_adv.billing_proxy.lib.domain.exceptions import (
    AgencyDoesNotExist,
    BadDuplicatedCharge,
    ClientByUidDoesNotExist,
    ClientContractMismatch,
    ClientDoesNotExist,
    ClientIsAgency,
    ClientIsNotAgency,
    ClientNotInAgency,
    ClientsDoNotExist,
    ClientsAreAlreadyInAgency,
    ClientsHaveOrdersWithAgency,
    ContractDoesNotExist,
    DomainException,
    ExternalOrdersDoNotExist,
    MultipleProductsMatched,
    NoActiveVersionsForProduct,
    NonCPMProduct,
    NoProductsMatched,
    OrderDoesNotExist,
    OrdersBillInFuture,
    OrdersDoNotExist,
    ProductAgencyMismatch,
    ProductClientMismatch,
    ProductDoesNotExist,
    ProductIsInactive,
    ProductServiceMismatch,
    UserIsAssignedToAnotherClient,
    InvalidBillingType,
    NoPlatformsSpecified,
    NoProductVersionsSpecified,
    ConflictingProductVersionTimeSpans,
    ConflictingProducts,
    ProductHasZeroCost,
    ClientsAlreadyBoundToOverlappingProducts,
)


class BadDtParameter(Exception):
    pass


@enum.unique
class ErrorCodes(enum.Enum):
    DATA_VALIDATION_ERROR = 0
    CLIENT_DOES_NOT_EXIST = 1
    AGENCY_DOES_NOT_EXIST = 2
    CLIENTS_DO_NOT_EXIST = 3
    CONTRACT_DOES_NOT_EXIST = 4
    CLIENT_CONTRACT_MISMATCH = 5
    CLIENT_IS_AGENCY = 6
    CLIENT_IS_NOT_AGENCY = 7
    CLIENT_NOT_IN_AGENCY = 8
    PRODUCT_DOES_NOT_EXIST = 9
    PRODUCT_IS_INACTIVE = 10
    PRODUCT_CLIENT_MISMATCH = 11
    PRODUCT_AGENCY_MISMATCH = 12
    NO_PRODUCTS_MATCHED = 13
    MULTIPLE_PRODUCTS_MATCHED = 14
    ORDER_DOES_NOT_EXIST = 15
    ORDERS_DO_NOT_EXIST = 16
    BILL_FOR_TS_IN_FUTURE = 17
    NON_CPM_PRODUCT = 18
    NO_ACTIVE_VERSIONS_FOR_PRODUCT = 19
    BAD_DUPLICATE_CHARGE = 20
    CLIENT_BY_UID_DOES_NOT_EXIST = 21
    PRODUCT_SERVICE_DISMATCH = 22
    USER_IS_ASSIGNED_TO_ANOTHER_CLIENT = 23
    INVALID_BILLING_TYPE = 24
    NO_PLATFORM_SPECIFIED = 25
    NO_PRODUCT_VERSIONS_SPECIFIED = 26
    CONFLICTING_PRODUCT_VERSION_TIME_SPANS = 27
    CONFLICTING_PRODUCTS = 28
    CLIENTS_ARE_ALREADY_IN_AGENCY = 29
    CLIENTS_HAVE_ORDERS_WITH_AGENCY = 30
    PRODUCT_HAS_ZERO_COST = 31
    CLIENTS_ALREADY_BOUND_TO_OVERLAPPING_PRODUCTS = 32


exception_error_codes = {
    AgencyDoesNotExist: ErrorCodes.AGENCY_DOES_NOT_EXIST,
    BadDuplicatedCharge: ErrorCodes.BAD_DUPLICATE_CHARGE,
    ClientDoesNotExist: ErrorCodes.CLIENT_DOES_NOT_EXIST,
    ClientByUidDoesNotExist: ErrorCodes.CLIENT_BY_UID_DOES_NOT_EXIST,
    ClientsDoNotExist: ErrorCodes.CLIENTS_DO_NOT_EXIST,
    ClientContractMismatch: ErrorCodes.CLIENT_CONTRACT_MISMATCH,
    ClientIsAgency: ErrorCodes.CLIENT_IS_AGENCY,
    ClientIsNotAgency: ErrorCodes.CLIENT_IS_NOT_AGENCY,
    ClientNotInAgency: ErrorCodes.CLIENT_NOT_IN_AGENCY,
    ContractDoesNotExist: ErrorCodes.CONTRACT_DOES_NOT_EXIST,
    ProductDoesNotExist: ErrorCodes.PRODUCT_DOES_NOT_EXIST,
    ProductIsInactive: ErrorCodes.PRODUCT_IS_INACTIVE,
    ProductClientMismatch: ErrorCodes.PRODUCT_CLIENT_MISMATCH,
    ProductAgencyMismatch: ErrorCodes.PRODUCT_AGENCY_MISMATCH,
    ProductServiceMismatch: ErrorCodes.PRODUCT_SERVICE_DISMATCH,
    NoProductsMatched: ErrorCodes.NO_PRODUCTS_MATCHED,
    MultipleProductsMatched: ErrorCodes.MULTIPLE_PRODUCTS_MATCHED,
    OrderDoesNotExist: ErrorCodes.ORDER_DOES_NOT_EXIST,
    OrdersDoNotExist: ErrorCodes.ORDERS_DO_NOT_EXIST,
    OrdersBillInFuture: ErrorCodes.BILL_FOR_TS_IN_FUTURE,
    NonCPMProduct: ErrorCodes.NON_CPM_PRODUCT,
    NoActiveVersionsForProduct: ErrorCodes.NO_ACTIVE_VERSIONS_FOR_PRODUCT,
    UserIsAssignedToAnotherClient: ErrorCodes.USER_IS_ASSIGNED_TO_ANOTHER_CLIENT,
    InvalidBillingType: ErrorCodes.INVALID_BILLING_TYPE,
    NoPlatformsSpecified: ErrorCodes.NO_PLATFORM_SPECIFIED,
    NoProductVersionsSpecified: ErrorCodes.NO_PRODUCT_VERSIONS_SPECIFIED,
    ConflictingProductVersionTimeSpans: ErrorCodes.CONFLICTING_PRODUCT_VERSION_TIME_SPANS,
    ConflictingProducts: ErrorCodes.CONFLICTING_PRODUCTS,
    ClientsAreAlreadyInAgency: ErrorCodes.CLIENTS_ARE_ALREADY_IN_AGENCY,
    ClientsHaveOrdersWithAgency: ErrorCodes.CLIENTS_HAVE_ORDERS_WITH_AGENCY,
    ProductHasZeroCost: ErrorCodes.PRODUCT_HAS_ZERO_COST,
    ClientsAlreadyBoundToOverlappingProducts: ErrorCodes.CLIENTS_ALREADY_BOUND_TO_OVERLAPPING_PRODUCTS,
}

__all__ = [
    "exception_error_codes",
    "AgencyDoesNotExist",
    "BadDtParameter",
    "ClientDoesNotExist",
    "ClientByUidDoesNotExist",
    "ClientsDoNotExist",
    "ClientContractMismatch",
    "ClientIsAgency",
    "ClientIsNotAgency",
    "ClientNotInAgency",
    "ClientsAreAlreadyInAgency",
    "ClientsHaveOrdersWithAgency",
    "ContractDoesNotExist",
    "DomainException",
    "ProductDoesNotExist",
    "ProductIsInactive",
    "ProductClientMismatch",
    "ProductAgencyMismatch",
    "ProductServiceMismatch",
    "NoProductsMatched",
    "MultipleProductsMatched",
    "OrdersBillInFuture",
    "OrderDoesNotExist",
    "OrdersDoNotExist",
    "NonCPMProduct",
    "NoActiveVersionsForProduct",
    "ExternalOrdersDoNotExist",
    "UserIsAssignedToAnotherClient",
]
