from marshmallow import fields, post_load

from .base import StrictSchema


class OrderNotify2Schema(StrictSchema):
    ServiceID = fields.Integer(data_key="ServiceID")
    ServiceOrderID = fields.Integer(data_key="ServiceOrderID")
    ConsumeQty = fields.Decimal(data_key="ConsumeQty")
    Tid = fields.Integer(data_key="Tid")

    @post_load
    def to_dict(self, data):
        return {
            "order_id": data["ServiceOrderID"],
            "new_limit": data["ConsumeQty"],
            "tid": data["Tid"],
            "service_id": data["ServiceID"],
        }
