from maps_adv.billing_proxy.lib.domain import (
    CampaignType,
    CreativeType,
    CurrencyType,
    FixTimeIntervalType,
    OrderSize,
    PlatformType,
    RubricName,
    CpmCoefFieldType,
    TargetingCriterion,
)
from maps_adv.billing_proxy.proto import common_pb2, products_pb2

# Values' pairs for protobuf and internal enums used in schemas
enums_maps = {
    "platform": [
        (common_pb2.PlatformType.Value("MAPS"), PlatformType.MAPS),
        (common_pb2.PlatformType.Value("METRO"), PlatformType.METRO),
        (common_pb2.PlatformType.Value("NAVI"), PlatformType.NAVI),
    ],
    "campaign_type": [
        (common_pb2.CampaignType.Value("PIN_ON_ROUTE"), CampaignType.PIN_ON_ROUTE),
        (common_pb2.CampaignType.Value("BILLBOARD"), CampaignType.BILLBOARD),
        (
            common_pb2.CampaignType.Value("ZERO_SPEED_BANNER"),
            CampaignType.ZERO_SPEED_BANNER,
        ),
        (
            common_pb2.CampaignType.Value("CATEGORY_SEARCH_PIN"),
            CampaignType.CATEGORY_SEARCH_PIN,
        ),
        (common_pb2.CampaignType.Value("ROUTE_BANNER"), CampaignType.ROUTE_BANNER),
        (common_pb2.CampaignType.Value("VIA_POINTS"), CampaignType.VIA_POINTS),
        (
            common_pb2.CampaignType.Value("OVERVIEW_BANNER"),
            CampaignType.OVERVIEW_BANNER,
        ),
        (common_pb2.CampaignType.Value("PROMOCODE"), CampaignType.PROMOCODE),
    ],
    "creative_type": [
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("BILLBOARD"),
            CreativeType.BILLBOARD,
        ),
        (products_pb2.CpmCalculationInput.CreativeType.Value("PIN"), CreativeType.PIN),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("BANNER"),
            CreativeType.BANNER,
        ),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("TEXT"),
            CreativeType.TEXT,
        ),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("ICON"),
            CreativeType.ICON,
        ),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("PIN_SEARCH"),
            CreativeType.PIN_SEARCH,
        ),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("LOGO_AND_TEXT"),
            CreativeType.LOGO_AND_TEXT,
        ),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("VIA_POINT"),
            CreativeType.VIA_POINT,
        ),
        (
            products_pb2.CpmCalculationInput.CreativeType.Value("AUDIO_BANNER"),
            CreativeType.AUDIO_BANNER,
        ),
    ],
    "currency": [
        (common_pb2.CurrencyType.Value("RUB"), CurrencyType.RUB),
        (common_pb2.CurrencyType.Value("BYN"), CurrencyType.BYN),
        (common_pb2.CurrencyType.Value("TRY"), CurrencyType.TRY),
        (common_pb2.CurrencyType.Value("KZT"), CurrencyType.KZT),
        (common_pb2.CurrencyType.Value("EUR"), CurrencyType.EUR),
        (common_pb2.CurrencyType.Value("USD"), CurrencyType.USD),
    ],
    "rubric": [
        (products_pb2.CpmCalculationInput.AdvRubric.Value("COMMON"), RubricName.COMMON),
        (products_pb2.CpmCalculationInput.AdvRubric.Value("AUTO"), RubricName.AUTO),
        (products_pb2.CpmCalculationInput.AdvRubric.Value("REALTY"), RubricName.REALTY),
    ],
    "order_size": [
        (products_pb2.CpmCalculationInput.OrderSize.Value("SMALL"), OrderSize.SMALL),
        (products_pb2.CpmCalculationInput.OrderSize.Value("BIG"), OrderSize.BIG),
        (
            products_pb2.CpmCalculationInput.OrderSize.Value("VERY_BIG"),
            OrderSize.VERY_BIG,
        ),
    ],
    "time_interval": [
        (products_pb2.Fix.TimeIntervalType.Value("DAILY"), FixTimeIntervalType.DAILY),
        (products_pb2.Fix.TimeIntervalType.Value("WEEKLY"), FixTimeIntervalType.WEEKLY),
        (
            products_pb2.Fix.TimeIntervalType.Value("MONTHLY"),
            FixTimeIntervalType.MONTHLY,
        ),
    ],
    "targeting_criterion": [
        (
            products_pb2.CpmCalculationCoef.TargetingCriterion.Value("AGE"),
            TargetingCriterion.AGE,
        ),
        (
            products_pb2.CpmCalculationCoef.TargetingCriterion.Value("GENDER"),
            TargetingCriterion.GENDER,
        ),
        (
            products_pb2.CpmCalculationCoef.TargetingCriterion.Value("INCOME"),
            TargetingCriterion.INCOME,
        ),
        (
            products_pb2.CpmCalculationCoef.TargetingCriterion.Value("AUDIENCE"),
            TargetingCriterion.AUDIENCE,
        ),
        (
            products_pb2.CpmCalculationCoef.TargetingCriterion.Value("SEGMENT"),
            TargetingCriterion.SEGMENT,
        ),
    ],
    "cpm_coef_field_type": [
        (
            products_pb2.CpmCalculationCoef.FieldType.Value("CREATIVE"),
            CpmCoefFieldType.CREATIVE,
        ),
        (
            products_pb2.CpmCalculationCoef.FieldType.Value("RUBRIC"),
            CpmCoefFieldType.RUBRIC,
        ),
        (
            products_pb2.CpmCalculationCoef.FieldType.Value("TARGETING"),
            CpmCoefFieldType.TARGETING,
        ),
        (
            products_pb2.CpmCalculationCoef.FieldType.Value("MONTHLY"),
            CpmCoefFieldType.MONTHLY,
        ),
    ],
}
