from aiohttp.web import Request, Response

from maps_adv.billing_proxy.lib.api.api_providers import BalanceApiProvider


class Resources:
    __slots__ = ("_provider",)

    def __init__(self, provider: BalanceApiProvider):
        self._provider = provider

    async def notify_orders(self, request: Request) -> Response:
        data = await request.json()
        result = await self._provider.notify_orders(data)

        status = 200 if result else 422
        return Response(status=status)

    async def notify_orders_from_geoprod(self, request: Request) -> Response:
        data = await request.json()
        result = await self._provider.notify_orders_from_geoprod(data)

        status = 200 if result else 422
        return Response(status=status)

    async def reconciliation(self, request: Request) -> Response:
        result = await self._provider.build_reconciliation_report(
            request.query.get("dt")
        )
        return Response(
            text=result, headers={"Content-Type": "text/csv; charset=utf-8"}
        )

    async def geoprod_reconciliation(self, request: Request) -> Response:
        await self._provider.load_geoprod_reconciliation_report(request.query.get("dt"))
        return Response(status=200)
