import pytz

from datetime import datetime

from maps_adv.common.config_loader import ConfigLoader, Option


config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("BALANCE_XMLRPC_API_HOST", default="localhost"),
    Option("BALANCE_XMLRPC_API_PORT", default=8080, converter=int),
    Option("BALANCE_XMLRPC_API_PATH", default="xmlrpc"),
    Option("BALANCE_SERVICE_ID", default=110, converter=int),
    Option("BALANCE_SERVICE_TOKEN", default=""),
    Option("BALANCE_OPERATOR_UID", default=None, converter=int),
    Option("GEOPRODUCT_DEFAULT_UID", converter=int),
    Option("GEOPRODUCT_URL", default="localhost"),
    Option("SKIP_BALANCE_API_CALL_ON_ORDERS_CHARGE", default=False, converter=bool),
    Option("TVMTOOL_PORT", default=2, converter=int),
    Option("TVMTOOL_LOCAL_AUTHTOKEN", default=None),
    Option("WARDEN_URL", default="http://localhost/"),
    Option("USE_RECALCULATE_STATISTIC_MODE", default=False, converter=bool),
    Option("GEOPROD_SERVICE_ID", default=37, converter=int),
    Option("YT_CLUSTER", default="hahn"),
    Option("YT_TOKEN", default=None),
    Option(
        "YT_RECOINCILIATION_REPORT_DIR",
        default="//home/geoadv/geoprod/production/billing/geoadv_agency_log",
    ),
    Option(
        "SEASONAL_COEFS_SINCE",
        default=pytz.timezone("Europe/Moscow").localize(
            datetime(year=2022, month=1, day=1, hour=0, minute=0, second=0)
        ),
        converter=datetime.fromisoformat,
    ),
)
