from .base import CpmUndefined, CpmData, CpmCoef
from .creative import cpm_filters as creative_cpm_filters
from .registry import FiltersRegistry
from .rubric_name import cpm_filters as rubric_name_cpm_filters
from .targeting import cpm_filters as targeting_cpm_filters
from .values_map import cpm_filters as values_map_cpm_filters

cpm_filters_registry = FiltersRegistry(
    dict(
        **creative_cpm_filters,
        **rubric_name_cpm_filters,
        **targeting_cpm_filters,
        **values_map_cpm_filters,
    )
)

__all__ = ["CpmUndefined", "cpm_filters_registry", "CpmData", "CpmCoef"]
