from typing import Iterable, Mapping, Optional, Tuple

from .base import BaseCpmFilter


class FiltersRegistry(Mapping):
    def __init__(self, filters: Optional[Mapping[str, BaseCpmFilter]] = None):
        self._filters = {}
        if filters:
            for key, instance in filters.items():
                self._filters[key] = instance

    def __getitem__(self, key: str) -> BaseCpmFilter:
        return self._filters[key]

    def __contains__(self, key: str) -> bool:
        return key in self._filters

    def __len__(self) -> int:
        return len(self._filters)

    def __iter__(self) -> Iterable[str]:
        return iter(self._filters)

    def values(self) -> Iterable[BaseCpmFilter]:
        return self._filters.values()

    def items(self) -> Iterable[Tuple[str, BaseCpmFilter]]:
        return self._filters.items()
