class AgencyDoesNotExist(Exception):
    def __init__(self, *args, agency_id):
        super().__init__(*args)
        self.agency_id = agency_id


class ClientsDoNotExist(Exception):
    def __init__(self, *args, client_ids):
        super().__init__(*args)
        self.client_ids = client_ids


class OrdersDoNotExist(Exception):
    def __init__(self, *args, order_ids):
        super().__init__(*args)
        self.order_ids = order_ids


class ClientDoesNotExist(Exception):
    def __init__(self, *args, client_id):
        super().__init__(*args)
        self.client_id = client_id


class ProductDoesNotExist(Exception):
    def __init__(self, *args, product_id):
        super().__init__(*args)
        self.product_id = product_id


class ContractDoesNotExist(Exception):
    def __init__(self, *args, contract_id):
        super().__init__(*args)
        self.contract = contract_id


class ProductClientMismatch(Exception):
    def __init__(self, *args, product_id, client_ids):
        super().__init__(*args)
        self.product_id = product_id
        self.client_ids = client_ids


class UserIsAssignedToAnotherClient(Exception):
    def __init__(self, *args):
        super().__init__(*args)


class ConflictingProducts(Exception):
    def __init__(self, *args, product_ids):
        super().__init__(*args)
        self.product_ids = product_ids


class ClientsAlreadyBoundToOverlappingProducts(Exception):
    def __init__(self, *args, client_ids, platforms, currency):
        super().__init__(*args)
        self.client_ids = client_ids
        self.platforms = platforms
        self.currency = currency
