find_contract_by_id = """
    SELECT *
    FROM contracts
    WHERE id = $1
"""

list_contacts_by_client = """
    SELECT *
    FROM contracts
    WHERE client_id = $1
    ORDER BY id
"""

upsert_contract = """
    INSERT INTO contracts (
        id,
        external_id,
        client_id,
        currency,
        is_active,
        date_start,
        date_end,
        payment_type,
        preferred
    )
    VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)
    ON CONFLICT (id) DO UPDATE SET
        external_id = excluded.external_id,
        currency = excluded.currency,
        is_active = excluded.is_active,
        date_start = excluded.date_start,
        date_end = excluded.date_end,
        payment_type = excluded.payment_type
"""

set_client_contracts_inactive = """
    UPDATE contracts
    SET is_active = FALSE
    WHERE contracts.client_id = $1
        AND NOT contracts.id = ANY($2::bigint[])
"""
