import sqlalchemy as sa


# noinspection PyAbstractClass
class Column(sa.Column):
    def __init__(self, *args, **kwargs):
        kwargs.setdefault("nullable", False)
        super().__init__(*args, **kwargs)


# noinspection PyAbstractClass
class MoneyColumn(Column):
    def __init__(self, *args, **kwargs):
        if len(args) < 2:
            kwargs["type_"] = sa.Numeric(precision=18, scale=6)
        super().__init__(*args, **kwargs)


class DateTimeTZ(sa.DateTime):
    def __init__(self, *args, **kwargs):
        kwargs["timezone"] = True
        super().__init__(*args, **kwargs)
