import json

from asyncpg import Connection

from smb.common.pgswim import PoolType, SwimEngine

__all__ = ["DB", "SwimEngine", "PoolType"]


class DB(SwimEngine):
    @staticmethod
    async def _set_codecs(con: Connection):
        await con.set_type_codec(
            "json", schema="pg_catalog", encoder=json.dumps, decoder=json.loads
        )
        await con.set_type_codec(
            "jsonb", schema="pg_catalog", encoder=json.dumps, decoder=json.loads
        )
