from enum import Enum, auto, unique


class DBEnum(Enum):
    def _generate_next_value_(name, start, count, last_values):
        return name

    def __str__(self):
        return self.value


@unique
class BillingType(DBEnum):
    CPM = auto()
    FIX = auto()


@unique
class FixTimeIntervalType(Enum):
    DAILY = auto()
    WEEKLY = auto()
    MONTHLY = auto()


@unique
class CampaignType(DBEnum):
    PIN_ON_ROUTE = auto()
    BILLBOARD = auto()
    ZERO_SPEED_BANNER = auto()
    CATEGORY_SEARCH_PIN = auto()
    ROUTE_BANNER = auto()
    VIA_POINTS = auto()
    OVERVIEW_BANNER = auto()
    PROMOCODE = auto()


@unique
class CurrencyType(DBEnum):
    RUB = auto()
    BYN = auto()
    TRY = auto()
    KZT = auto()
    EUR = auto()
    USD = auto()


@unique
class PaymentType(DBEnum):
    PRE = auto()
    POST = auto()


@unique
class PlatformType(DBEnum):
    MAPS = auto()
    METRO = auto()
    NAVI = auto()


@unique
class OrderOperationType(DBEnum):
    CREDIT = auto()
    DEBIT = auto()


# FIXME: move to common?
class DbEnumConverter:
    _name_getter = lambda v: v.name  # noqa: E731

    @classmethod
    def to_enum(cls, enum_class, value):
        if isinstance(value, (list, tuple)):
            return type(value)(map(lambda v: enum_class[v], value))
        elif value is not None:
            return enum_class[value]
        else:
            return None

    @classmethod
    def from_enum(cls, value):
        if isinstance(value, (list, tuple)):
            return type(value)(map(cls._name_getter, value))
        elif value is not None:
            return value.name
        else:
            return None
