"""empty message

Revision ID: f9842586227f
Revises:
Create Date: 2019-09-09 17:49:24.456794

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

# revision identifiers, used by Alembic.
revision = "f9842586227f"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "clients",
        sa.Column("id", sa.BigInteger(), autoincrement=False, nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("email", sa.String(length=256), nullable=False),
        sa.Column("phone", sa.String(length=64), server_default="", nullable=False),
        sa.Column("is_agency", sa.Boolean(), server_default="FALSE", nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clients")),
    )
    op.create_table(
        "products",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("oracle_id", sa.BigInteger(), nullable=False),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(length=256), nullable=False),
        sa.Column("act_text", sa.String(length=256), nullable=False),
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column(
            "currency",
            sa.Enum("RUB", "BYN", "TRY", "KZT", "EUR", "USD", name="currencytype"),
            nullable=False,
        ),
        sa.Column(
            "billing_type", sa.Enum("CPM", "FIX", name="billingtype"), nullable=False
        ),
        sa.Column(
            "billing_data",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default=sa.text("'{}'"),
            nullable=False,
        ),
        sa.Column("vat_value", sa.Numeric(), nullable=False),
        sa.Column(
            "campaign_type",
            sa.Enum(
                "PIN_ON_ROUTE",
                "BILLBOARD",
                "ZERO_SPEED_BANNER",
                "CATEGORY_SEARCH_PIN",
                "ROUTE_BANNER",
                "VIA_POINTS",
                "OVERVIEW_BANNER",
                "PROMOCODE",
                name="campaigntype",
            ),
            nullable=False,
        ),
        sa.Column(
            "platform",
            sa.Enum("MAPS", "METRO", "NAVI", name="platformtype"),
            nullable=False,
        ),
        sa.Column("min_budget", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.Column(
            "cpm_filters", postgresql.ARRAY(sa.String(length=128)), nullable=False
        ),
        sa.Column("comment", sa.String(length=512), nullable=False),
        sa.Column("available_for_agencies", sa.Boolean(), nullable=False),
        sa.Column("available_for_internal", sa.Boolean(), nullable=False),
        sa.Column(
            "active_from",
            maps_adv.billing_proxy.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column(
            "active_to",
            maps_adv.billing_proxy.lib.db.columns.DateTimeTZ(),
            nullable=True,
        ),
        sa.CheckConstraint(
            "jsonb_typeof(billing_data) = 'object'",
            name=op.f("ck_products_billing_data_object"),
        ),
        sa.CheckConstraint(
            "active_from <= active_to",
            name=op.f("ck_products_active_from_earlier_active_to"),
        ),
        sa.CheckConstraint("min_budget >= 0.0", name=op.f("ck_products_positive")),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_products")),
    )
    op.create_table(
        "agency_clients",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("agency_id", sa.BigInteger(), nullable=True),
        sa.Column("client_id", sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(
            ["agency_id"],
            ["clients.id"],
            name=op.f("fk_agency_clients_agency_id_clients"),
        ),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["clients.id"],
            name=op.f("fk_agency_clients_client_id_clients"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_agency_clients")),
    )
    op.create_index(
        "agency_clients_unique_ind_agency_id_notnull",
        "agency_clients",
        ["agency_id", "client_id"],
        unique=True,
        postgresql_where=sa.text("agency_id IS NOT NULL"),
    )
    op.create_index(
        "agency_clients_unique_ind_agency_id_null",
        "agency_clients",
        ["client_id"],
        unique=True,
        postgresql_where=sa.text("agency_id IS NULL"),
    )
    op.create_table(
        "contracts",
        sa.Column("id", sa.BigInteger(), autoincrement=False, nullable=False),
        sa.Column("external_id", sa.VARCHAR(length=64), nullable=False),
        sa.Column("client_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "currency",
            sa.Enum("RUB", "BYN", "TRY", "KZT", "EUR", "USD", name="currencytype"),
            nullable=False,
        ),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("date_start", sa.Date(), nullable=False),
        sa.Column("date_end", sa.Date(), nullable=True),
        sa.Column(
            "payment_type", sa.Enum("PRE", "POST", name="paymenttype"), nullable=False
        ),
        sa.Column("preferred", sa.Boolean(), server_default="FALSE", nullable=False),
        sa.ForeignKeyConstraint(
            ["client_id"], ["clients.id"], name=op.f("fk_contracts_client_id_clients")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_contracts")),
    )
    op.create_index(
        "contracts_external_id_hash_ind",
        "contracts",
        ["external_id"],
        unique=False,
        postgresql_using="hash",
    )
    op.create_table(
        "product_client_restrictions",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column("client_id", sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["clients.id"],
            name=op.f("fk_product_client_restrictions_client_id_clients"),
        ),
        sa.ForeignKeyConstraint(
            ["product_id"],
            ["products.id"],
            name=op.f("fk_product_client_restrictions_product_id_products"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_product_client_restrictions")),
    )
    op.create_index(
        "product_client_restrictions_unique_ind",
        "product_client_restrictions",
        ["product_id", "client_id"],
        unique=True,
    )
    op.create_table(
        "orders",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column(
            "created_at",
            maps_adv.billing_proxy.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("tid", sa.BigInteger(), server_default=sa.text("0"), nullable=False),
        sa.Column("title", sa.String(length=256), nullable=False),
        sa.Column("act_text", sa.String(length=256), nullable=False),
        sa.Column("text", sa.Text(), nullable=False),
        sa.Column("comment", sa.String(length=1024), nullable=False),
        sa.Column("client_id", sa.BigInteger(), nullable=False),
        sa.Column("agency_id", sa.BigInteger(), nullable=True),
        sa.Column("contract_id", sa.BigInteger(), nullable=False),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column("daily_budget", sa.Numeric(precision=18, scale=4), nullable=True),
        sa.Column(
            "limit",
            sa.Numeric(precision=18, scale=4),
            server_default=sa.text("0"),
            nullable=False,
        ),
        sa.Column(
            "consumed",
            sa.Numeric(precision=18, scale=4),
            server_default=sa.text("0"),
            nullable=False,
        ),
        sa.CheckConstraint('"limit" >= 0.0', name=op.f("ck_orders_limit_nonnegative")),
        sa.CheckConstraint(
            "consumed >= 0.0", name=op.f("ck_orders_consumed_nonnegative")
        ),
        sa.CheckConstraint(
            "daily_budget IS NULL OR daily_budget >= 0.0",
            name=op.f("ck_orders_daily_budget_null_or_nonnegative"),
        ),
        sa.CheckConstraint("tid >= 0", name=op.f("ck_orders_tid_nonnegative")),
        sa.ForeignKeyConstraint(
            ["agency_id"], ["clients.id"], name=op.f("fk_orders_agency_id_clients")
        ),
        sa.ForeignKeyConstraint(
            ["client_id"], ["clients.id"], name=op.f("fk_orders_client_id_clients")
        ),
        sa.ForeignKeyConstraint(
            ["contract_id"],
            ["contracts.id"],
            name=op.f("fk_orders_contract_id_contracts"),
        ),
        sa.ForeignKeyConstraint(
            ["product_id"], ["products.id"], name=op.f("fk_orders_product_id_products")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_orders")),
    )
    op.create_table(
        "order_logs",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column(
            "created_at",
            maps_adv.billing_proxy.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "op_type",
            sa.Enum("CREDIT", "DEBIT", name="orderoperationtype"),
            nullable=False,
        ),
        sa.Column("order_id", sa.BigInteger(), nullable=False),
        sa.Column("amount", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.Column("limit", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.Column("consumed", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.CheckConstraint(
            '"limit" >= 0.0', name=op.f("ck_order_logs_limit_nonnegative")
        ),
        sa.CheckConstraint(
            "consumed >= 0.0", name=op.f("ck_order_logs_consumed_nonnegative")
        ),
        sa.ForeignKeyConstraint(
            ["order_id"], ["orders.id"], name=op.f("fk_order_logs_order_id_orders")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_order_logs")),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("order_logs")
    op.drop_table("orders")
    op.drop_index(
        "product_client_restrictions_unique_ind",
        table_name="product_client_restrictions",
    )
    op.drop_table("product_client_restrictions")
    op.drop_index("contracts_external_id_hash_ind", table_name="contracts")
    op.drop_table("contracts")
    op.drop_index(
        "agency_clients_unique_ind_agency_id_null", table_name="agency_clients"
    )
    op.drop_index(
        "agency_clients_unique_ind_agency_id_notnull", table_name="agency_clients"
    )
    op.drop_table("agency_clients")
    op.drop_table("products")
    op.drop_table("clients")
    op.execute(
        """
        DROP TYPE billingtype;
        DROP TYPE campaigntype;
        DROP TYPE currencytype;
        DROP TYPE platformtype;
        DROP TYPE paymenttype;
        DROP TYPE orderoperationtype;
        """
    )
    # ### end Alembic commands ###
