"""empty message

Revision ID: 722da12857b9
Revises: 5cdcc4d4fcc2
Create Date: 2019-12-24 22:20:37.421682

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

import maps_adv.billing_proxy.lib.db.columns
import maps_adv.billing_proxy.lib.db.enums

# revision identifiers, used by Alembic.
revision = "722da12857b9"
down_revision = "5cdcc4d4fcc2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "product_rules_versions",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column(
            "active_from",
            maps_adv.billing_proxy.lib.db.columns.DateTimeTZ(),
            nullable=False,
        ),
        sa.Column(
            "active_to",
            maps_adv.billing_proxy.lib.db.columns.DateTimeTZ(),
            nullable=True,
        ),
        sa.Column(
            "billing_data",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default=sa.text("'{}'"),
            nullable=False,
        ),
        sa.Column("min_budget", sa.Numeric(precision=18, scale=4), nullable=False),
        sa.Column(
            "cpm_filters", postgresql.ARRAY(sa.String(length=128)), nullable=False
        ),
        sa.CheckConstraint(
            "jsonb_typeof(billing_data) = 'object'",
            name=op.f("ck_product_rules_versions_billing_data_object"),
        ),
        sa.CheckConstraint(
            "active_from <= active_to",
            name=op.f("ck_product_rules_versions_active_from_earlier_active_to"),
        ),
        sa.CheckConstraint(
            "min_budget >= 0.0", name=op.f("ck_product_rules_versions_positive")
        ),
        sa.ForeignKeyConstraint(
            ["product_id"],
            ["products.id"],
            name=op.f("fk_product_rules_versions_product_id_products"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_product_rules_versions")),
    )
    op.create_index(
        "product_rules_versions_product_id_btree_ind",
        "product_rules_versions",
        ["product_id"],
        unique=False,
    )
    op.create_index(
        "product_rules_versions_product_id_version_btree_unique_ind",
        "product_rules_versions",
        ["product_id", "version"],
        unique=True,
    )

    # Transfer data from products to product_versions, without deleting yet
    op.execute(
        """
            INSERT INTO product_rules_versions (product_id, version, active_from, active_to, billing_data, min_budget, cpm_filters)
            SELECT id, version, active_from, active_to, billing_data, min_budget, cpm_filters
            FROM products
        """  # noqa: E501
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "product_rules_versions_product_id_version_btree_unique_ind",
        table_name="product_rules_versions",
    )
    op.drop_index(
        "product_rules_versions_product_id_btree_ind",
        table_name="product_rules_versions",
    )
    op.drop_table("product_rules_versions")
    # ### end Alembic commands ###
