"""empty message

Revision ID: b82813d20f81
Revises: 722da12857b9
Create Date: 2020-01-09 15:29:57.819717

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "b82813d20f81"
down_revision = "722da12857b9"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("products", "min_budget")
    op.drop_column("products", "version")
    op.drop_column("products", "billing_data")
    op.drop_column("products", "active_from")
    op.drop_column("products", "active_to")
    op.drop_column("products", "cpm_filters")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "products",
        sa.Column(
            "cpm_filters",
            postgresql.ARRAY(sa.VARCHAR(length=128)),
            autoincrement=False,
            nullable=False,
            server_default="{}",
        ),
    )
    op.add_column(
        "products",
        sa.Column(
            "active_to",
            postgresql.TIMESTAMP(timezone=True),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.add_column(
        "products",
        sa.Column(
            "active_from",
            postgresql.TIMESTAMP(timezone=True),
            autoincrement=False,
            nullable=False,
            server_default="NOW()",
        ),
    )
    op.add_column(
        "products",
        sa.Column(
            "billing_data",
            postgresql.JSONB(astext_type=sa.Text()),
            server_default=sa.text("'{}'::jsonb"),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "products",
        sa.Column(
            "version",
            sa.INTEGER(),
            autoincrement=False,
            nullable=False,
            server_default="1",
        ),
    )
    op.add_column(
        "products",
        sa.Column(
            "min_budget",
            sa.NUMERIC(precision=18, scale=4),
            autoincrement=False,
            nullable=False,
            server_default="0.0",
        ),
    )
    # ### end Alembic commands ###
